package ru.yandex.direct.core.entity.keyword.model;


import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public enum Place {
    PREMIUM(3),
    FIRST(2),
    GARANT(1),
    PREMIUM1(10),
    PREMIUM2(11),
    PREMIUM3(12),
    PREMIUM4(13),
    GUARANTEE1(20),
    GUARANTEE2(21),
    GUARANTEE3(22),
    GUARANTEE4(23),
    ROTATION(0);

    private final int code;
    private static final Map<Integer, Place> ENUM_MAP = Arrays.stream(values())
            .collect(Collectors.toMap(Place::getCode, x -> x));

    Place(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public static Place convertFromDb(Long code) {
        if (code == null) {
            return null;
        }
        return Optional.ofNullable(ENUM_MAP.get(code.intValue()))
                .orElseThrow(() -> new IllegalArgumentException("No enum constant " + code));
    }

    public static Long convertToDb(Place place) {
        return place == null ? null : (long) place.code;
    }
}
