package ru.yandex.direct.core.entity.moderation.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.asset.BaseAssetModerationData;

public class BaseBannerModerationData extends BaseModerationData {

    @JsonProperty("social_advertising")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Boolean isSocialAdvertisement;

    @JsonProperty("business_unit")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Long businessUnit;

    @JsonProperty("user_flags")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private List<Integer> userFlags;

    @JsonProperty("assets")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private List<BaseAssetModerationData> assets;

    public Boolean getIsSocialAdvertisement() {
        return isSocialAdvertisement;
    }

    public void setIsSocialAdvertisement(Boolean socialAdvertisement) {
        isSocialAdvertisement = socialAdvertisement;
    }

    public Long getBusinessUnit() {
        return businessUnit;
    }

    public void setBusinessUnit(Long businessUnit) {
        this.businessUnit = businessUnit;
    }

    public List<Integer> getUserFlags() {
        return userFlags;
    }

    public void setUserFlags(List<Integer> userFlags) {
        this.userFlags = userFlags;
    }

    public List<BaseAssetModerationData> getAssets() {
        return assets;
    }

    public void addAsset(BaseAssetModerationData asset) {
        if (assets == null) {
            assets = new ArrayList<>();
        }
        assets.add(asset);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseBannerModerationData that = (BaseBannerModerationData) o;
        return Objects.equals(isSocialAdvertisement, that.isSocialAdvertisement)
                && Objects.equals(businessUnit, that.businessUnit)
                && Objects.equals(userFlags, that.userFlags)
                && Objects.equals(assets, that.assets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), isSocialAdvertisement, businessUnit, userFlags, assets);
    }
}
