package ru.yandex.direct.core.entity.moderation.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

public class BaseModerationData {

    public static final String ASAP_PROPERTY_NAME = "asap";

    /**
     * Флаг для ускоренной модерации.
     */
    private Boolean asSoonAsPossible;

    @JsonProperty(ASAP_PROPERTY_NAME)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Boolean getAsSoonAsPossible() {
        return asSoonAsPossible;
    }

    public void setAsSoonAsPossible(Boolean asSoonAsPossible) {
        this.asSoonAsPossible = asSoonAsPossible;
    }

    public BaseModerationData withAsSoonAsPossible(Boolean asSoonAsPossible) {
        this.asSoonAsPossible = asSoonAsPossible;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseModerationData that = (BaseModerationData) o;
        return Objects.equals(asSoonAsPossible, that.asSoonAsPossible);
    }

    @Override
    public int hashCode() {
        return Objects.hash(asSoonAsPossible);
    }
}
