package ru.yandex.direct.core.entity.moderation.model.asset;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ImageModerationData extends BaseAssetModerationData {
    public static final String TYPE_NAME = "image";

    private String host;
    private String imageHash;
    private Long mdsGroupId;
    private String namespace;
    private String name;

    @Override
    public String getId() {
        return imageHash;
    }

    @JsonProperty("host")
    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty("image_hash")
    public String getImageHash() {
        return imageHash;
    }

    public void setImageHash(String imageHash) {
        this.imageHash = imageHash;
    }

    @JsonProperty("mds_group_id")
    public Long getMdsGroupId() {
        return mdsGroupId;
    }

    public void setMdsGroupId(Long mdsGroupId) {
        this.mdsGroupId = mdsGroupId;
    }

    @JsonProperty("namespace")
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
