package ru.yandex.direct.core.entity.organization.model;

import javax.annotation.Nullable;

import ru.yandex.direct.dbschema.ppc.enums.OrganizationsStatusPublish;

public enum OrganizationStatusPublish {
    UNKNOWN,

    PUBLISHED,

    UNPUBLISHED,

    MOVED,

    CLOSED,

    TEMPORARILY_CLOSED;

    @Nullable
    public static OrganizationStatusPublish fromSource(OrganizationsStatusPublish value) {
        if (value == null) return null;
        switch(value) {
            case unknown:
                return UNKNOWN;
            case published:
                return PUBLISHED;
            case unpublished:
                return UNPUBLISHED;
            default: throw new IllegalStateException("No such value: " + value);
        }
    }

    @Nullable
    public static OrganizationsStatusPublish toSource(OrganizationStatusPublish value) {
        if (value == null) return null;
        switch(value) {
            case UNKNOWN:
                return OrganizationsStatusPublish.unknown;
            case PUBLISHED:
            case MOVED:
            case CLOSED:
            case TEMPORARILY_CLOSED:
                return OrganizationsStatusPublish.published;
            case UNPUBLISHED:
                return OrganizationsStatusPublish.unpublished;
            default: throw new IllegalStateException("No such value: " + value);
        }
    }
}
