package ru.yandex.direct.core.entity.performancefilter.model;

import com.fasterxml.jackson.annotation.JsonValue

enum class Operator(@JsonValue val stringRepresentation: String) {
    GREATER(">"),
    LESS("<"),
    EQUALS("=="),
    NOT_EQUALS("not"),
    RANGE("<->"),
    CONTAINS("ilike"),
    NOT_CONTAINS("not ilike"),
    EXISTS("exists"),
    UNKNOWN("unknown");

    override fun toString(): String = stringRepresentation

    companion object {
        private val valueByString = values().associateBy { it.toString() }

        // Нужно только для совместимости со старым кодом в performancefilter
        @JvmStatic
        fun fromString(string: String): Operator = valueByString.getOrDefault(string, UNKNOWN)
    }
}
