package ru.yandex.direct.core.entity.performancefilter.model;

import java.util.Objects;

import javax.annotation.Nullable;

import org.apache.commons.lang3.NotImplementedException;

import static com.google.common.base.Preconditions.checkState;

public class PerformanceFilterCondition<V> implements IPerformanceFilterCondition {
    public PerformanceFilterCondition(String fieldName, Operator operator, String stringValue) {
        this.fieldName = fieldName;
        this.operator = operator;
        this.stringValue = stringValue;
    }

    public static final String PARSED_VALUE = "parsed_value";

    private final String fieldName;
    private final Operator operator;
    private final String stringValue;
    private V parsedValue;
    private boolean isParsed = false;

    public String getFieldName() {
        return fieldName;
    }

    @Override
    public void setFieldName(String fieldName) {
        throw new NotImplementedException("do not use it");
    }

    @Override
    public PerformanceFilterCondition<V> withFieldName(String fieldName) {
        throw new NotImplementedException("do not use it");
    }

    public Operator getOperator() {
        return operator;
    }

    @Override
    public void setOperator(Operator operator) {
        throw new NotImplementedException("do not use it");
    }

    @Override
    public PerformanceFilterCondition<V> withOperator(Operator operator) {
        throw new NotImplementedException("do not use it");
    }

    public String getStringValue() {
        return stringValue;
    }

    @Override
    public void setStringValue(String stringValue) {
        throw new NotImplementedException("do not use it");
    }

    @Override
    public PerformanceFilterCondition<V> withStringValue(String stringValue) {
        return null;
    }

    @Nullable
    public V getParsedValue() {
        checkState(isParsed, "Value is not parsed");
        return parsedValue;
    }

    public void setParsedValue(V parsedValue) {
        checkState(!isParsed, "Value is already parsed");
        this.parsedValue = parsedValue;
        isParsed = true;
    }

    public PerformanceFilterCondition<V> withParsedValue(V parsedValue) {
        setParsedValue(parsedValue);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PerformanceFilterCondition<?> that = (PerformanceFilterCondition<?>) o;
        return isParsed == that.isParsed && Objects.equals(fieldName, that.fieldName) && operator == that.operator && Objects.equals(stringValue, that.stringValue) && Objects.equals(parsedValue, that.parsedValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(fieldName, operator, stringValue, parsedValue, isParsed);
    }

    @Override
    public String toString() {
        return "PerformanceFilterCondition{" +
                "fieldName='" + fieldName + '\'' +
                ", operator=" + operator +
                ", stringValue='" + stringValue + '\'' +
                ", parsedValue=" + parsedValue +
                ", isParsed=" + isParsed +
                '}';
    }
}
