package ru.yandex.direct.core.entity.recommendation;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import ru.yandex.direct.feature.FeatureName;

import static ru.yandex.direct.feature.FeatureName.RECOMMENDATION_AUTOPAY_STOPPED;
import static ru.yandex.direct.feature.FeatureName.RECOMMENDATION_MAIN_INVOICE;
import static ru.yandex.direct.feature.FeatureName.RECOMMENDATION_OVERDRAFT_DEBT;

public enum RecommendationType {
    dailyBudget(1L, true),

    removePagesFromBlackList(2L, true),

    sendLicensesBanks(3L, false),

    sendLicensesPharmacy(4L, false),

    sendLicensesMedServices(5L, false),

    switchOnAutotargeting(6L, true),

    addMorePicturesToAdgroup(7L, true),

    changeAdGroupForModeration(8L, false),

    changeAdGroupWithLowStat(9L, false),

    removePagesFromBlackListOfACampaign(11L, true),

    changeBannerForModeration(12L, false),

    addTitleExtension(14L, false),

    addSiteLinks(15L, false),

    addAdditionItemCallouts(16L, false),

    addBannerDisplayHrefs(17L, false),

    addImageToBanner(19L, false),

    addTurboWebSiteToBanner(20L, false),

    addBannerFormats(21L, false),

    uploadAppropriateCreatives(22L, false),

    chooseAppropriatePlacementsForAdGroup(23L, false),

    chooseAppropriatePlacementsForBanner(24L, false),

    // тут просто предлагается +30% к текущему недельному бюджету сделать
    // используется в плашке
    weeklyBudget(25L, true),

    // а тут недельный бюджет рассчитывается из таблицы ОКР
    increaseStrategyWeeklyBudget(26L, true),

    increaseStrategyTargetCPA(27L, true),

    decreaseStrategyTargetROI(28L, true),

    addBannerFormatsForPriceSalesCorrectness(29L, false),

    autopayStopped(30L, false, RECOMMENDATION_AUTOPAY_STOPPED),

    overdraftDebt(31L, false, RECOMMENDATION_OVERDRAFT_DEBT),

    mainInvoice(32L, false, RECOMMENDATION_MAIN_INVOICE),

    addBannerFormatsForPriceSalesCorrectnessInParentCampaign(33L, false),

    videoButton(34L, false),
    ;

    private static final Map<Long, RecommendationType> ID_TO_ENUM = Arrays.stream(values())
            .collect(Collectors.toMap(RecommendationType::getId, e -> e));

    private final Long id;
    private final FeatureName feature;
    private final boolean appliable;

    RecommendationType(Long id, boolean appliable, FeatureName feature) {
        this.id = id;
        this.feature = feature;
        this.appliable = appliable;
    }

    RecommendationType(Long id, boolean appliable) {
        this(id, appliable, null);
    }

    public Long getId() {
        return id;
    }

    public FeatureName getFeature() {
        return feature;
    }

    public boolean isAppliable() {
        return appliable;
    }

    public static RecommendationType fromId(@Nullable Long id) {
        if (id == null) {
            return null;
        }
        RecommendationType result = ID_TO_ENUM.get(id);
        if (result == null) {
            throw new IllegalArgumentException("Unknown id " + id);
        }
        return result;
    }
}
