package ru.yandex.direct.core.entity.retargeting;

import java.util.Arrays;

import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.core.entity.crypta.AudienceType;

public class Constants {

    /* retargeting conditions selection */
    public static final long MAX_LIMIT = 10000;
    public static final long DEFAULT_LIMIT = MAX_LIMIT;
    public static final long MIN_OFFSET = 0;
    public static final long DEFAULT_OFFSET = MIN_OFFSET;
    public static final int MIN_IDS_PER_REQUEST = 1;
    public static final int MAX_IDS_PER_GET = 10000;

    /* retargeting conditions list */
    public static final int MAX_RET_CONDITIONS_PER_REQUEST = 1000;
    public static final int MAX_RET_CONDITIONS_PER_CLIENT = 2000;

    /* retargeting condition */
    public static final int MAX_NAME_LENGTH = 250;
    public static final int MAX_DESCRIPTION_LENGTH = 4096;
    public static final int MIN_RULES_PER_CONDITION = 1;
    public static final int MIN_RULES_PER_INTEREST_CONDITION = 0;
    public static final int MAX_RULES_PER_CONDITION = 50;
    public static final int MAX_RULES_PER_CONDITION_FOR_CA = 1;
    public static final int MAX_INTEREST_RULES_PER_CONDITION = 3;
    public static final int RULES_PER_CONDITION_FOR_INTEREST_TARGETING = 1;

    /* retargeting condition rule */
    public static final int MIN_GOALS_PER_RULE = 1;
    public static final int MAX_GOALS_PER_RULE = 250;
    public static final int MAX_GOALS_PER_RULE_FOR_CA = 30;
    public static final int MAX_GOALS_PER_INTEREST_RULE = 10;
    public static final int GOALS_PER_RULE_FOR_INTEREST_TARGETING = 1;

    /* retargeting condition goal */
    public static final int MIN_GOAL_TIME = 1;
    public static final int INTEREST_LINK_TIME_VALUE = 90;
    public static final int MAX_GOAL_TIME = 540;
    public static final int AUDIENCE_TIME_VALUE = 540;
    public static final int SEGMENT_TIME_VALUE = 540;
    public static final int CDP_SEGMENT_TIME_VALUE = 540;
    public static final int CRYPTA_GOAL_TIME_VALUE = 0;

    /* retargeting conditions list */
    public static final int MIN_RETARGETINGS_PER_REQUEST = 1;
    public static final int MAX_RETARGETINGS_PER_REQUEST = 1000;
    public static final int MAX_RETARGETINGS_IN_ADGROUP = 50;
    public static final int MAX_RETARGETINGS_IN_CPM_ADGROUP = 1;
    public static final int DEFAULT_AUTOBUDGET_PRIORITY = 3;

    /**
     * Некоторые коллекции целей крипты не должны содержать все значения с одинаковым parentId.
     * Например, мужской и женский пол.
     * Так как это сужает возможную аудиторию из-за наличия неразмеченных людей.
     */
    public static final ImmutableSet<Long> CRYPTA_PARENT_IDS_FOR_VALIDATION = Arrays.stream(AudienceType.values())
            .filter(audienceType -> !audienceType.isAllValuesAllowed())
            .map(AudienceType::getTypedValue)
            .collect(ImmutableSet.toImmutableSet());
}
