package ru.yandex.direct.core.entity.retargeting.model;

import java.util.Objects;
import java.util.Set;

import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

/**
 * Составной первичный ключ таблицы camp_metrika_goals
 */
public class CampMetrikaGoalId implements Model, Comparable<CampMetrikaGoalId> {
    public static final ModelProperty<CampMetrikaGoalId, Long> CAMPAIGN_ID =
            ModelProperty.create(CampMetrikaGoalId.class, "campaignId", CampMetrikaGoalId::getCampaignId,
                    CampMetrikaGoalId::setCampaignId);

    public static final ModelProperty<CampMetrikaGoalId, Long> GOAL_ID =
            ModelProperty.create(CampMetrikaGoalId.class, "goalId", CampMetrikaGoalId::getGoalId,
                    CampMetrikaGoalId::setGoalId);

    private Long campaignId;

    private Long goalId;

    public Long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public CampMetrikaGoalId withCampaignId(Long campaignId) {
        setCampaignId(campaignId);
        return this;
    }

    public Long getGoalId() {
        return goalId;
    }

    public void setGoalId(Long goalId) {
        this.goalId = goalId;
    }

    public CampMetrikaGoalId withGoalId(Long goalId) {
        setGoalId(goalId);
        return this;
    }

    public static Set<ModelProperty> allModelProperties() {
        return ImmutableSet.of(
                CAMPAIGN_ID,
                GOAL_ID
        );
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ru.yandex.direct.core.entity.retargeting.model.CampMetrikaGoalId{");
        sb.append("campaignId=").append(campaignId);
        sb.append(", goalId=").append(goalId);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampMetrikaGoalId that = (CampMetrikaGoalId) o;
        return Objects.equals(campaignId, that.campaignId)
                && Objects.equals(goalId, that.goalId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                campaignId,
                goalId
        );
    }

    @Override
    public int compareTo(CampMetrikaGoalId o) {
        int campaignIdsCompared = campaignId.compareTo(o.campaignId);
        if (campaignIdsCompared != 0) {
            return campaignIdsCompared;
        }
        return goalId.compareTo(o.goalId);
    }
}
