package ru.yandex.direct.core.entity.retargeting.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * Представляет собой абстракцию цели-интереса
 * Предназначен для заполнения поля condition_json у retargeting_conditions, для условий нацеливания по интересам
 * В целях, в retargeting_conditions, записывается только id и time поля
 */
@JsonIgnoreProperties(value = {"goal_type"}, ignoreUnknown = true)
public class GoalInterest extends Goal {

    public GoalInterest(Long id, Integer time) {
        super.setId(id);
        super.setTime(time);
    }
}
