package ru.yandex.direct.core.entity.retargeting.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import static ru.yandex.direct.core.entity.retargeting.model.GoalSource.CRYPTA;
import static ru.yandex.direct.core.entity.retargeting.model.GoalSource.DIRECT;
import static ru.yandex.direct.core.entity.retargeting.model.GoalSource.METRIKA;

/**
 * Тип цели - retargeting_goals.goal_type
 * GOAL, COUNTER, SEGMENT, ECOMMERCE, AUDIENCE, AB_SEGMENT, CDP_SEGMENT - типы целей метрики
 * SOCIAL_DEMO, FAMILY, INTERESTS - типы целей крипты
 * AB_SEGMENT - Экспериментальные сегменты
 * LAL_SEGMENT - look-alike сегмент для целей/сегментов метрики и аудиторий
 */
public enum GoalType {
    @JsonProperty("goal")
    GOAL(METRIKA),
    @JsonProperty("segment")
    SEGMENT(METRIKA),
    @JsonProperty("ecommerce")
    ECOMMERCE(METRIKA),
    @JsonProperty("audience")
    AUDIENCE(METRIKA),
    @JsonProperty("ab_segment")
    AB_SEGMENT(METRIKA),
    @JsonProperty("cdp_segment")
    CDP_SEGMENT(METRIKA),
    @JsonProperty("social_demo")
    SOCIAL_DEMO(CRYPTA),
    /**
     * FAMILY - это Расширенный соцдем
     */
    @JsonProperty("family")
    FAMILY(CRYPTA),
    @JsonProperty("interests")
    INTERESTS(CRYPTA),
    @JsonProperty("behaviors")
    BEHAVIORS(CRYPTA),
    @JsonProperty("internal")
    INTERNAL(CRYPTA),
    @JsonProperty("audio_genres")
    AUDIO_GENRES(CRYPTA),
    @JsonProperty("brandsafety")
    BRANDSAFETY(CRYPTA),
    @JsonProperty("lal_segment")
    LAL_SEGMENT(DIRECT),
    @JsonProperty("content_category")
    CONTENT_CATEGORY(CRYPTA),
    @JsonProperty("content_genre")
    CONTENT_GENRE(CRYPTA),
    @JsonProperty("mobile")
    MOBILE(DIRECT),
    @JsonProperty("host")
    HOST(CRYPTA);

    private final GoalSource source;

    GoalType(GoalSource source) {
        this.source = source;
    }

    public boolean isMetrika() {
        return source == METRIKA;
    }

    public boolean isCrypta() {
        return source == CRYPTA;
    }

    public boolean isDirect() {
        return source == DIRECT;
    }

    public GoalSource getSource() {
        return source;
    }
}
