package ru.yandex.direct.core.entity.retargeting.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * Предназначен для заполнения поля condition_json у retargeting_conditions, для условий нацеливания по интересам.
 * Для таргетинга по интересам в condition_json записываются только цели и тип
 */
@JsonIgnoreProperties(value = {"interest_type", "section_id"}, ignoreUnknown = true)
public class RuleInterest extends Rule {

    public RuleInterest(RuleType ruleType, List<Goal> goals) {
        super.setType(ruleType);
        super.setGoals(goals);
    }
}
