package ru.yandex.direct.dbqueue;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Тип задачи: такие объекты надо делать глобальными константами, а потом использовать, чтобы информировать
 * методы dbqueue, с задачей какого типа хочет работать потребитель.
 * <p>
 * Ну и ещё это такой синтаксический сахар, чтобы java понимала, как специфицировать всякие generic-методы и классы.
 *
 * @param <A> тип аргументов задачи
 * @param <R> тип результата задачи
 */
@ParametersAreNonnullByDefault
public class DbQueueJobType<A, R> {
    private final String name;
    private final Class<A> argsClass;
    private final Class<R> resultClass;

    public DbQueueJobType(String name, Class<A> argsClass, Class<R> resultClass) {
        this.name = name;
        this.argsClass = argsClass;
        this.resultClass = resultClass;
    }

    public String getName() {
        return name;
    }

    public Class<A> getArgsClass() {
        return argsClass;
    }

    public Class<R> getResultClass() {
        return resultClass;
    }
}
