package ru.yandex.direct.dbqueue;

import java.time.Duration;

public class JobFailedWithTryLaterException extends RuntimeException {
    private final Duration tryLater;
    private final Object args;

    public JobFailedWithTryLaterException(Duration tryLater) {
        this.tryLater = tryLater;
        this.args = null;
    }

    public JobFailedWithTryLaterException(Duration tryLater, Object args) {
        this.tryLater = tryLater;
        this.args = args;
    }

    public JobFailedWithTryLaterException(Duration tryLater, String message) {
        super(message);
        this.tryLater = tryLater;
        this.args = null;
    }

    public JobFailedWithTryLaterException(Duration tryLater, String message, Throwable cause) {
        super(message, cause);
        this.tryLater = tryLater;
        this.args = null;
    }

    public Duration getTryLater() {
        return tryLater;
    }

    public Object getArgs() {
        return args;
    }
}
