package ru.yandex.direct.dbqueue;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkArgument;

@ParametersAreNonnullByDefault
public class LimitOffset {
    private static final int MAX_LIMIT = Integer.MAX_VALUE - 1;
    private final int limit;
    private final int offset;

    public LimitOffset(int limit, int offset) {
        checkArgument(limit >= 0);
        checkArgument(offset >= 0);
        this.limit = limit;
        this.offset = offset;
    }

    public static LimitOffset maxLimited() {
        return limited(MAX_LIMIT, 0);
    }

    public static LimitOffset limited(int limit) {
        return limited(limit, 0);
    }

    public static LimitOffset limited(int limit, int offset) {
        return new LimitOffset(limit, offset);
    }

    public int limit() {
        return this.limit;
    }

    public int offset() {
        return this.offset;
    }

    public <T> List<T> apply(List<T> items) {
        return items.stream()
                .skip(offset)
                .limit(limit)
                .collect(Collectors.toList());
    }
}
