package ru.yandex.direct.dbqueue.model;

import java.time.LocalDateTime;
import java.util.Objects;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;

/**
 * Задача в dbqueue. Такие объекты мэпятся практически "как есть" в одну из двух таблиц
 * в БД: dbqueue_jobs и dbqueue_job_result. В какую из них, определяется по полю status:
 * со статусами NEW и GRABBED попадают в jobs; со статусами FINISHED, FAILED и REVOKED
 * в job_archive.
 * <p>
 * Смысл этого в том, чтобы воркеры, которые активно обрабатывают задачи и перемешивают
 * данные, работали с таблицей jobs меньшего размера.
 *
 * @param <A> тип аргументов задачи
 * @param <R> тип результата задачи
 */
@SuppressWarnings("squid:S1845")
// поля и константы ModelProperty, названия которых отличаются только регистром, - это норма
public class DbQueueJob<A, R> implements ModelWithId {
    public static final ModelProperty<DbQueueJob, Long> ID =
            ModelProperty.create(DbQueueJob.class, "id", DbQueueJob::getId, DbQueueJob::setId);

    public static final ModelProperty<DbQueueJob, ClientId> CLIENT_ID =
            ModelProperty.create(DbQueueJob.class, "clientId", DbQueueJob::getClientId, DbQueueJob::setClientId);

    public static final ModelProperty<DbQueueJob, Long> UID =
            ModelProperty.create(DbQueueJob.class, "uid", DbQueueJob::getUid, DbQueueJob::setUid);

    public static final ModelProperty<DbQueueJob, Long> JOB_TYPE_ID =
            ModelProperty.create(DbQueueJob.class, "jobTypeId", DbQueueJob::getJobTypeId, DbQueueJob::setJobTypeId);

    public static final ModelProperty<DbQueueJob, String> NAMESPACE =
            ModelProperty.create(DbQueueJob.class, "namespace", DbQueueJob::getNamespace, DbQueueJob::setNamespace);

    public static final ModelProperty<DbQueueJob, DbQueueJobStatus> STATUS =
            ModelProperty.create(DbQueueJob.class, "status", DbQueueJob::getStatus, DbQueueJob::setStatus);

    public static final ModelProperty<DbQueueJob, Long> PRIORITY =
            ModelProperty.create(DbQueueJob.class, "priority", DbQueueJob::getPriority, DbQueueJob::setPriority);

    public static final ModelProperty<DbQueueJob, LocalDateTime> CREATION_TIME =
            ModelProperty.create(DbQueueJob.class, "creationTime", DbQueueJob::getCreationTime, DbQueueJob::setCreationTime);

    public static final ModelProperty<DbQueueJob, LocalDateTime> EXPIRATION_TIME =
            ModelProperty.create(DbQueueJob.class, "expirationTime", DbQueueJob::getExpirationTime, DbQueueJob::setExpirationTime);

    public static final ModelProperty<DbQueueJob, String> GRABBED_BY =
            ModelProperty.create(DbQueueJob.class, "grabbedBy", DbQueueJob::getGrabbedBy, DbQueueJob::setGrabbedBy);

    public static final ModelProperty<DbQueueJob, LocalDateTime> GRABBED_UNTIL =
            ModelProperty.create(DbQueueJob.class, "grabbedUntil", DbQueueJob::getGrabbedUntil, DbQueueJob::setGrabbedUntil);

    public static final ModelProperty<DbQueueJob, LocalDateTime> GRABBED_AT =
            ModelProperty.create(DbQueueJob.class, "grabbedAt", DbQueueJob::getGrabbedAt, DbQueueJob::setGrabbedAt);

    public static final ModelProperty<DbQueueJob, Long> TRY_COUNT =
            ModelProperty.create(DbQueueJob.class, "tryCount", DbQueueJob::getTryCount, DbQueueJob::setTryCount);

    public static final ModelProperty<DbQueueJob, LocalDateTime> RUN_AFTER =
            ModelProperty.create(DbQueueJob.class, "runAfter", DbQueueJob::getRunAfter, DbQueueJob::setRunAfter);

    private Long id;

    private ClientId clientId;

    private Long uid;

    private Long jobTypeId;

    private String namespace;

    private DbQueueJobStatus status;

    private A args;

    private Long priority;

    private LocalDateTime creationTime;

    private LocalDateTime expirationTime;

    private String grabbedBy;

    private LocalDateTime grabbedUntil;

    private LocalDateTime grabbedAt;

    private Long tryCount;

    private LocalDateTime runAfter;

    private R result;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public DbQueueJob<A, R> withId(Long id) {
        setId(id);
        return this;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public void setClientId(ClientId clientId) {
        this.clientId = clientId;
    }

    public DbQueueJob<A, R> withClientId(ClientId clientId) {
        setClientId(clientId);
        return this;
    }

    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public DbQueueJob<A, R> withUid(Long uid) {
        setUid(uid);
        return this;
    }

    public Long getJobTypeId() {
        return jobTypeId;
    }

    public void setJobTypeId(Long jobTypeId) {
        this.jobTypeId = jobTypeId;
    }

    public DbQueueJob<A, R> withJobTypeId(Long jobTypeId) {
        setJobTypeId(jobTypeId);
        return this;
    }

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public DbQueueJob<A, R> withNamespace(String namespace) {
        setNamespace(namespace);
        return this;
    }

    public DbQueueJobStatus getStatus() {
        return status;
    }

    public void setStatus(DbQueueJobStatus status) {
        this.status = status;
    }

    public DbQueueJob<A, R> withStatus(DbQueueJobStatus status) {
        setStatus(status);
        return this;
    }

    public A getArgs() {
        return args;
    }

    public void setArgs(A args) {
        this.args = args;
    }

    public DbQueueJob<A, R> withArgs(A args) {
        setArgs(args);
        return this;
    }

    public Long getPriority() {
        return priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public DbQueueJob<A, R> withPriority(Long priority) {
        setPriority(priority);
        return this;
    }

    public LocalDateTime getCreationTime() {
        return creationTime;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public DbQueueJob<A, R> withCreateTime(LocalDateTime createTime) {
        setCreationTime(createTime);
        return this;
    }

    public LocalDateTime getExpirationTime() {
        return expirationTime;
    }

    public void setExpirationTime(LocalDateTime expirationTime) {
        this.expirationTime = expirationTime;
    }

    public DbQueueJob<A, R> withExpirationType(LocalDateTime expirationType) {
        setExpirationTime(expirationType);
        return this;
    }

    public String getGrabbedBy() {
        return grabbedBy;
    }

    public void setGrabbedBy(String grabbedBy) {
        this.grabbedBy = grabbedBy;
    }

    public DbQueueJob<A, R> withGrabbedBy(String grabbedBy) {
        setGrabbedBy(grabbedBy);
        return this;
    }

    public LocalDateTime getGrabbedUntil() {
        return grabbedUntil;
    }

    public void setGrabbedUntil(LocalDateTime grabbedUntil) {
        this.grabbedUntil = grabbedUntil;
    }

    public DbQueueJob<A, R> withGrabbedUntil(LocalDateTime grabbedUntil) {
        setGrabbedUntil(grabbedUntil);
        return this;
    }

    public LocalDateTime getGrabbedAt() {
        return grabbedAt;
    }

    public void setGrabbedAt(LocalDateTime grabbedAt) {
        this.grabbedAt = grabbedAt;
    }

    public DbQueueJob<A, R> withGrabbedAt(LocalDateTime grabbedAt) {
        setGrabbedAt(grabbedAt);
        return this;
    }

    public Long getTryCount() {
        return tryCount;
    }

    public void setTryCount(Long tryCount) {
        this.tryCount = tryCount;
    }

    public DbQueueJob<A, R> withTryCount(Long tryCount) {
        setTryCount(tryCount);
        return this;
    }

    public LocalDateTime getRunAfter() {
        return runAfter;
    }

    public void setRunAfter(LocalDateTime runAfter) {
        this.runAfter = runAfter;
    }

    public DbQueueJob<A, R> withRunAfter(LocalDateTime runAfter) {
        setRunAfter(runAfter);
        return this;
    }

    public R getResult() {
        return result;
    }

    public void setResult(R result) {
        this.result = result;
    }

    public DbQueueJob<A, R> withResult(R result) {
        setResult(result);
        return this;
    }

    @Override
    public String toString() {
        return "DbQueueJob{" +
                "id=" + id +
                ", clientId=" + clientId +
                ", uid=" + uid +
                ", jobTypeId=" + jobTypeId +
                ", namespace='" + namespace + '\'' +
                ", status=" + status +
                ", args=" + args +
                ", priority=" + priority +
                ", creationTime=" + creationTime +
                ", expirationTime=" + expirationTime +
                ", grabbedBy='" + grabbedBy + '\'' +
                ", grabbedUntil=" + grabbedUntil +
                ", grabbedAt=" + grabbedAt +
                ", tryCount=" + tryCount +
                ", runAfter=" + runAfter +
                ", result=" + result +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        DbQueueJob that = (DbQueueJob) o;
        return Objects.equals(id, that.id)
                && Objects.equals(clientId, that.clientId)
                && Objects.equals(uid, that.uid)
                && Objects.equals(jobTypeId, that.jobTypeId)
                && Objects.equals(namespace, that.namespace)
                && Objects.equals(status, that.status)
                && Objects.equals(args, that.args)
                && Objects.equals(priority, that.priority)
                && Objects.equals(creationTime, that.creationTime)
                && Objects.equals(expirationTime, that.expirationTime)
                && Objects.equals(grabbedBy, that.grabbedBy)
                && Objects.equals(grabbedUntil, that.grabbedUntil)
                && Objects.equals(grabbedAt, that.grabbedAt)
                && Objects.equals(tryCount, that.tryCount)
                && Objects.equals(runAfter, that.runAfter)
                && Objects.equals(result, that.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                id,
                clientId,
                uid,
                jobTypeId,
                namespace,
                status,
                args,
                priority,
                creationTime,
                expirationTime,
                grabbedBy,
                grabbedUntil,
                grabbedAt,
                tryCount,
                runAfter,
                result
        );
    }
}
