package ru.yandex.direct.dbqueue.model;

import ru.yandex.direct.dbschema.ppc.enums.DbqueueJobArchiveStatus;
import ru.yandex.direct.dbschema.ppc.enums.DbqueueJobsStatus;

/**
 * статус задачи
 */
public enum DbQueueJobStatus {
    /**
     * новая
     */
    NEW,

    /**
     * кто-то обрабатывает
     */
    GRABBED,

    /**
     * завершена
     */
    FINISHED,

    /**
     * не обработана в результате ошибки
     */
    FAILED,

    /**
     * отозвана
     */
    REVOKED;

    public static DbQueueJobStatus fromJobsTableSource(DbqueueJobsStatus status) {
        switch (status) {
            case New:
                return NEW;
            case Grabbed:
                return GRABBED;
            default:
                throw new IllegalArgumentException("illegal status: " + status);
        }
    }

    public DbqueueJobsStatus toJobsTableSource() {
        switch (this) {
            case NEW:
                return DbqueueJobsStatus.New;
            case GRABBED:
                return DbqueueJobsStatus.Grabbed;
            default:
                throw new IllegalArgumentException("illegal status: " + this);
        }
    }

    public static DbQueueJobStatus fromJobArchiveTableSource(DbqueueJobArchiveStatus status) {
        switch (status) {
            case Finished:
                return FINISHED;
            case Failed:
                return FAILED;
            case Revoked:
                return REVOKED;
            default:
                throw new IllegalArgumentException("illegal status: " + status);
        }
    }

    public DbqueueJobArchiveStatus toJobArchiveTableSource() {
        switch (this) {
            case FINISHED:
                return DbqueueJobArchiveStatus.Finished;
            case FAILED:
                return DbqueueJobArchiveStatus.Failed;
            case REVOKED:
                return DbqueueJobArchiveStatus.Revoked;
            default:
                throw new IllegalArgumentException("illegal status: " + this);
        }
    }
}
