package ru.yandex.direct.dbqueue.repository;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import ru.yandex.direct.dbschema.ppcdict.tables.records.DbqueueJobTypesRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppcdict.tables.DbqueueJobTypes.DBQUEUE_JOB_TYPES;

@ParametersAreNonnullByDefault
public class DbQueueTypeMap {
    private final Cache<String, Long> typeToIdCache;
    private final DslContextProvider dslContextProvider;

    public DbQueueTypeMap(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;

        typeToIdCache = CacheBuilder.newBuilder()
                .maximumSize(1000)
                .expireAfterWrite(15, TimeUnit.MINUTES)
                .build();
    }

    public Long getJobTypeIdByTypeName(String typeName) {
        try {
            return typeToIdCache.get(typeName,
                    () -> {
                        DbqueueJobTypesRecord record = dslContextProvider.ppcdict()
                                .select(DBQUEUE_JOB_TYPES.JOB_TYPE_ID)
                                .from(DBQUEUE_JOB_TYPES)
                                .where(DBQUEUE_JOB_TYPES.JOB_TYPE.eq(typeName))
                                .fetchOneInto(DBQUEUE_JOB_TYPES);

                        if (record == null) {
                            throw new IllegalStateException("job type not registered: " + typeName);
                        }

                        return record.get(DBQUEUE_JOB_TYPES.JOB_TYPE_ID);
                    });
        } catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }
}
