package ru.yandex.direct.dbutil;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.TableField;

import static com.google.common.base.Preconditions.checkState;

@ParametersAreNonnullByDefault
public class DBUtils {
    private DBUtils() {
    }

    /**
     * из-за особенности построения запросов (join в зависимости наличия полей из таблиц) для чтения используются только {@link TableField}
     */
    public static TableField<?, ?> safeMapToTableField(Field<?> field) {
        checkState(field instanceof TableField, "field %s must be instance of TableField", field.getName());
        return (TableField<?, ?>) field;
    }
}
