package ru.yandex.direct.dbutil;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Аннотация для запросов в тестах, получающих id шарда из неразрешенных таблиц
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
public @interface QueryWithForbiddenShardMapping {

    /**
     * Коментарий почему игнорим
     */
    String value();
}
