package ru.yandex.direct.dbutil;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Аннотация для теста на запросы не по индексу, проставляется если мы знаем
 * что в данном конкретном методе есть запрос в базу не по ключу.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
public @interface QueryWithoutIndex {
    /**
     * Комментарий почему игнорим
     */
    String value();
}
