package ru.yandex.direct.dbutil.field;

import org.jooq.Condition;
import org.jooq.SelectField;

import static org.jooq.impl.DSL.field;

public class SetField {

    private final SelectField<String> origin;

    public SetField(SelectField<String> origin) {
        this.origin = origin;
    }

    /**
     * Проверяет, что строка {@code item} присутствует в {@code SET}'е
     *
     * @param item элемент, который необходимо проверить на вхождение в набор
     * @return {@link Condition} с результатом
     */
    public Condition contains(String item) {
        return field("FIND_IN_SET({0}, {1})", item, origin).ne(0);
    }
}
