package ru.yandex.direct.dbutil.sharding;

import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;

import ru.yandex.direct.dbschema.ppcdict.Tables;

/**
 * Pure auto increment keys for ShardSupport
 */
public enum AutoIncrementKey {
    PHID(Tables.INC_PHID),
    RET_ID(Tables.INC_RET_ID),
    AID(Tables.INC_AID),
    SL_ID(Tables.INC_SL_ID),
    MW_ID(Tables.INC_MW_ID),
    MAPS_ID(Tables.INC_MAPS_ID),
    REPORT_ID(Tables.INC_REPORT_ID),
    MCB_PHRASES_ID(Tables.INC_MCB_PHRASES_ID),
    USERS_NOTIFICATION_ID(Tables.INC_USERS_NOTIFICATION_ID),
    MEDIAPLAN_PHID(Tables.INC_MEDIAPLAN_PHID),
    MEDIAPLAN_RET_ID(Tables.INC_MEDIAPLAN_RET_ID),
    MEDIAPLAN_MPID(Tables.INC_MEDIAPLAN_MPID),
    DYN_ID(Tables.INC_DYN_ID),
    DYN_COND_ID(Tables.INC_DYN_COND_ID),
    OPT_CAMP_REQUEST_ID(Tables.INC_OPT_CAMP_REQUEST_ID),
    OPT_CAMP_POSTPONE_ID(Tables.INC_OPT_CAMP_POSTPONE_ID),
    DOUBLES_REQUEST_ID(Tables.INC_DOUBLES_REQUEST_ID),
    CR_ID(Tables.INC_CR_ID),
    CLIENT_DOMAINS_RECORD_ID(Tables.INC_CLIENT_DOMAINS_RECORD_ID),
    CLIENT_DOMAINS_SYNC_ID(Tables.INC_CLIENT_DOMAINS_SYNC_ID),
    CLIENT_DOMAINS_STRIPPED_RECORD_ID(Tables.INC_CLIENT_DOMAINS_STRIPPED_RECORD_ID),
    MOBILE_CONTENT_ID(Tables.INC_MOBILE_CONTENT_ID),
    HIERARCHICAL_MULTIPLIER_ID(Tables.INC_HIERARCHICAL_MULTIPLIER_ID),
    FEED_ID(Tables.INC_FEED_ID),
    FILTERED_FEED_ID(Tables.INC_FILTERED_FEED_ID),
    PERF_FILTER_ID(Tables.INC_PERF_FILTER_ID),
    ADDITIONS_ITEM_ID(Tables.INC_ADDITIONS_ITEM_ID),
    JOB_ID(Tables.INC_JOB_ID),
    BSEXPORT_ITER_ID(Tables.INC_BSEXPORT_ITER_ID),
    CAESAR_ITER_ID(Tables.INC_CAESAR_ITER_ID),
    DSP_CREATIVE_CAESAR_ITER_ID(Tables.INC_DSP_CREATIVE_CAESAR_ITER_ID),
    BS_ORDER_ID(Tables.INC_BS_ORDER_ID),
    IMAGE_ID(Tables.INC_IMAGE_ID),
    BANNER_CREATIVE_ID(Tables.INC_BANNER_CREATIVE_ID),
    DEAL_NOTIFICATION_ID(Tables.INC_DEAL_NOTIFICATION_ID),
    MDS_ID(Tables.INC_MDS_ID),
    FREELANCER_PROJECT_ID(Tables.INC_FREELANCER_PROJECT_ID),
    CLIENTS_RELATION_ID(Tables.INC_CLIENTS_RELATIONS_ID),
    CLIENTS_AVATARS_ID(Tables.INC_CLIENTS_AVATARS_ID),
    FREELANCERS_CARD_ID(Tables.INC_FREELANCERS_CARD_ID),
    LAL_SEGMENTS_ID(Tables.INC_LAL_SEGMENTS),
    MOBILE_APP_ID(Tables.INC_MOBILE_APP_ID),
    MOBILE_APP_GOAL_ID(Tables.INC_MOBILE_GOALS_ID),
    MOBILE_APP_TRACKER_ID(Tables.INC_MOBILE_APP_TRACKER_ID),
    PIXEL_ID(Tables.INC_PIXEL_ID),
    AGENCY_OFFLINE_REPORT(Tables.INC_AGENCY_OFFLINE_REPORT_ID),
    OFFLINE_REPORT(Tables.INC_OFFLINE_REPORT_ID),
    ADGROUP_ADDITIONAL_TARGETING_ID(Tables.INC_ADGROUP_ADDITIONAL_TARGETINGS),
    MODERATE_BANNER_PAGE_ID(Tables.INC_MODERATE_BANNER_PAGE_ID),
    CLIENT_DIALOG_ID(Tables.INC_CLIENT_DIALOG_ID),
    CONTENT_PROMOTION_VIDEO_ID(Tables.INC_CONTENT_PROMOTION_VIDEO_ID),
    CONTENT_PROMOTION_ID(Tables.INC_CONTENT_PROMOTION_ID),
    TURBO_APP_INFO_ID(Tables.INC_TURBO_APPS_INFO_ID),
    CLIENT_PHONE_ID(Tables.INC_CLIENT_PHONE_ID),
    CALLTRACKING_SETTINGS_ID(Tables.INC_CALLTRACKING_SETTINGS_ID),
    DAAS_BRIEF_ID(Tables.INC_DAAS_BRIEF_ID),
    BANNER_ADDITIONAL_HREFS_ID(Tables.INC_BANNER_ADDITIONAL_HREFS_ID),
    BANNER_MULTICARDS_MULTICARD_ID(Tables.INC_BANNER_MULTICARDS_MULTICARD_ID),
    CLIENTS_CASHBACK_PROGRAM_ID(Tables.INC_CLIENT_CASHBACK_PROGRAM_ID),
    CLIENT_CASHBACK_HISTORY_ID(Tables.INC_CLIENT_CASHBACK_HISTORY_ID),
    CLIENT_CASHBACK_DETAILS_ID(Tables.INC_CLIENT_CASHBACK_DETAILS_ID),
    CAMP_ADDITIONAL_TARGETINGS_ID(Tables.INC_CAMP_ADDITIONAL_TARGETINGS_ID),
    CLIENT_ADDITIONAL_TARGETINGS_ID(Tables.INC_CLIENT_ADDITIONAL_TARGETINGS_ID),
    CLIENT_MCC_REQUEST_ID(Tables.INC_CLIENT_MCC_REQUESTS_ID),
    REVERSE_CLIENTS_RELATIONS_ID(Tables.INC_REVERSE_CLIENTS_RELATIONS_ID),
    CAMPAIGNS_PROMOTIONS_ID(Tables.INC_CAMPAIGNS_PROMOTIONS_IDS);

    private final String name;
    private final Table<? extends Record> table;
    private final Field<?> keyField;

    AutoIncrementKey(Table<? extends Record> table) {
        Field<?>[] fields = table.fields();
        if (fields.length != 1) {
            throw new IllegalStateException("Table " + table.getName() + " must have exactly 1 column");
        }
        this.name = fields[0].getName();
        this.table = table;
        this.keyField = fields[0];
    }

    public String getName() {
        return name;
    }

    public Table<? extends Record> getTable() {
        return table;
    }

    public Field<?> getKeyField() {
        return keyField;
    }
}
