package ru.yandex.direct.dbutil.sharding;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import static ru.yandex.direct.utils.JsonUtils.toJson;

@JsonAutoDetect
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class DbShardsIdsLogRecord {
    private LocalDateTime logTime;
    private String host;
    private Number reqid;
    private String key;
    private List<Number> ids;
    private Map<String, Object> insertData;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd:HH:mm:ss")
    public LocalDateTime getLogTime() {
        return logTime;
    }

    public DbShardsIdsLogRecord withLogTime(LocalDateTime logTime) {
        this.logTime = logTime;
        return this;
    }

    public String getHost() {
        return host;
    }

    public DbShardsIdsLogRecord withHost(String host) {
        this.host = host;
        return this;
    }

    public Number getReqid() {
        return reqid;
    }

    public DbShardsIdsLogRecord withReqid(long reqid) {
        this.reqid = reqid;
        return this;
    }

    public String getKey() {
        return key;
    }

    public DbShardsIdsLogRecord withKey(String key) {
        this.key = key;
        return this;
    }

    public List<Number> getIds() {
        return ids;
    }

    public DbShardsIdsLogRecord withIds(List<Number> ids) {
        this.ids = ids;
        return this;
    }

    public Map<String, Object> getInsertData() {
        return insertData;
    }

    public DbShardsIdsLogRecord withInsertData(Map<String, Object> insertData) {
        this.insertData = insertData;
        return this;
    }

    @Override
    public String toString() {
        return toJson(this);
    }
}
