package ru.yandex.direct.dbutil.sharding;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.tools.Convert;

import static com.google.common.base.Preconditions.checkState;

@ParametersAreNonnullByDefault
class ValuesNormalizer {

    private ValuesNormalizer() {
        // no instantiation
    }

    static Object normalizeValue(Object value, ShardKey key) {
        if (key.getType() == ShardKeyType.STR) {
            checkState(value instanceof String, "Values for key %s must be strings", key.getName());
            value = ((String) value).toLowerCase();
        }
        return normalizeValue(value, key.getKeyField());
    }

    static <T> T normalizeValue(Object value, Field<T> field) {
        return normalizeValue(value, field.getType());
    }

    static <T> T normalizeValue(Object value, Class<T> type) {
        return Convert.convert(value, type);
    }
}
