package ru.yandex.direct.dbutil.wrapper;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.TransactionalCallable;
import org.jooq.TransactionalRunnable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@Component
public class DslContextProvider {
    private final DatabaseWrapperProvider databaseWrapperProvider;

    @Autowired
    public DslContextProvider(DatabaseWrapperProvider databaseWrapperProvider) {
        this.databaseWrapperProvider = databaseWrapperProvider;
    }

    public DSLContext ppc(int shard) {
        return databaseWrapperProvider.get(ShardedDb.PPC, shard).getDslContext();
    }

    public DSLContext ppcdict() {
        return databaseWrapperProvider.get(SimpleDb.PPCDICT).getDslContext();
    }

    public DSLContext ppclog() {
        return databaseWrapperProvider.get(SimpleDb.PPCLOG).getDslContext();
    }

    public DSLContext monitor() {
        return databaseWrapperProvider.get(SimpleDb.MONITOR).getDslContext();
    }

    public DSLContext chassis() {
        return databaseWrapperProvider.get(SimpleDb.CHASSIS).getDslContext();
    }

    public void ppcTransaction(int shard, TransactionalRunnable runnable) {
        ppc(shard).transaction(runnable);
    }

    public <T> T ppcTransactionResult(int shard, TransactionalCallable<T> callable) {
        return ppc(shard).transactionResult(callable);
    }

    public void ppcdictTransaction(TransactionalRunnable runnable) {
        ppcdict().transaction(runnable);
    }

    public <T> T ppcdictTransactionResult(TransactionalCallable<T> callable) {
        return ppcdict().transactionResult(callable);
    }

    public void monitorTransaction(TransactionalRunnable runnable) {
        monitor().transaction(runnable);
    }
}
