package ru.yandex.direct.dbutil.wrapper;


import org.jooq.ExecuteContext;
import org.jooq.impl.DefaultExecuteListener;

import ru.yandex.direct.tracing.Trace;
import ru.yandex.direct.tracing.TraceProfile;

/**
 * Слушатель, занимающийся профилированием JOOQ-запросов через Trace.profile
 */
public class ProfilingListener extends DefaultExecuteListener {
    private String dbname;
    private TraceProfile profile = null;

    public ProfilingListener(String dbname) {
        this.dbname = dbname;
    }

    private String queryTypeString(ExecuteContext ctx) {
        switch (ctx.type()) {
            case READ:
                return "db:read";
            case WRITE:
                return "db:write";
            case DDL:
                return "db:ddl";
            case BATCH:
                return "db:write"; // batch statements are usually writes
            default:
                return "db:query";
        }
    }

    @Override
    public void start(ExecuteContext ctx) {
        if (profile != null) {
            throw new ProfilingListenerException("Listener already initialized. The listener is not thread-safe, " +
                    "and must not be reused for multiple queries. " +
                    "Please use a separate Listener object for every query.");
        }
        profile = Trace.current().profile(queryTypeString(ctx), dbname);
    }

    @Override
    public void end(ExecuteContext ctx) {
        if (profile == null) {
            throw new ProfilingListenerException("Listener was not properly initialized to handle the profiling. " +
                    "You must call listener.start before calling listener.end");
        }
        profile.close();
        profile = null;
    }
}
