package ru.yandex.direct.dbutil.wrapper;

public enum ShardedDb {
    PPC("ppc");

    private final String name;

    ShardedDb(String name) {
        this.name = name;
    }

    /**
     * Вернуть название базы данных для заданного shard-а
     */
    public String getDbNameForShard(int shard) {
        if (shard <= 0) {
            throw new IllegalArgumentException("shard: " + shard);
        }
        return name + ":" + shard;
    }

    @Override
    public String toString() {
        return name;
    }
}
