package ru.yandex.direct.adfoxmessaging;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;

import ru.yandex.direct.adfoxmessaging.protos.AdfoxDealCreatePayload;
import ru.yandex.direct.adfoxmessaging.protos.AdfoxDealUpdatePayload;
import ru.yandex.direct.adfoxmessaging.protos.CommonMessage;
import ru.yandex.direct.adfoxmessaging.protos.DirectDealUpdatePayload;

public class AdfoxMessagingUtils {

    /**
     * Реестр используемых типов
     */
    private static final JsonFormat.TypeRegistry TYPE_REGISTRY = JsonFormat.TypeRegistry.newBuilder()
            .add(AdfoxDealCreatePayload.getDescriptor())
            .add(AdfoxDealUpdatePayload.getDescriptor())
            .add(DirectDealUpdatePayload.getDescriptor())
            .build();

    public static CommonMessage parseJson(String messageJson) throws InvalidProtocolBufferException {
        CommonMessage.Builder builder = CommonMessage.newBuilder();
        getParser().merge(messageJson, builder);
        return builder.build();
    }

    public static String toJson(MessageOrBuilder message) throws InvalidProtocolBufferException {
        return getPrinter().print(message);
    }

    static JsonFormat.Printer getHumanReadablePrinter() {
        return JsonFormat.printer().usingTypeRegistry(TYPE_REGISTRY);
    }

    static JsonFormat.Printer getPrinter() {
        // пропускаем ненужные пробельные символы
        return JsonFormat.printer().omittingInsignificantWhitespace().usingTypeRegistry(TYPE_REGISTRY);
    }

    static JsonFormat.Parser getParser() {
        return JsonFormat.parser().usingTypeRegistry(TYPE_REGISTRY);
    }

}
