package ru.yandex.direct.ess.client.repository

import org.springframework.stereotype.Repository
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.dbutil.QueryWithoutIndex
import ru.yandex.direct.dbutil.wrapper.DslContextProvider

@Repository
open class EssAdditionalObjectsRepository(private val dslContextProvider: DslContextProvider) {
    companion object {
        const val DELETE_CHUNK_SIZE = 10_000
    }

    open fun addLogicObjectsForProcessor(shard: Int, logicProcessorName: String, logicObjects: List<String>) {
        if (logicObjects.isEmpty()) return

        var insertStep = dslContextProvider.ppc(shard)
            .insertInto(Tables.ESS_ADDITIONAL_OBJECTS)
            .columns(Tables.ESS_ADDITIONAL_OBJECTS.LOGIC_PROCESS_NAME, Tables.ESS_ADDITIONAL_OBJECTS.LOGIC_OBJECT)
        logicObjects.forEach { insertStep = insertStep.values(logicProcessorName, it) }

        insertStep.execute()
    }

    open fun clearLogicObjects(shard: Int, limit: Int? = null) {

        if (limit != null) deleteWithLimit(shard, limit)
        else deleteChunked(shard)
    }

    @QueryWithoutIndex("Запрос на удаление из таблицы, которая на чтение никем не используется, удаление делается редко")
    private fun deleteWithLimit(shard: Int, limit: Int) {
        dslContextProvider.ppc(shard)
            .deleteFrom(Tables.ESS_ADDITIONAL_OBJECTS)
            .limit(limit)
            .execute()
    }

    @QueryWithoutIndex("Запрос на удаление из таблицы, которая на чтение никем не используется, удаление делается редко")
    private fun deleteChunked(shard: Int) {
        do {
            val deletedRows = dslContextProvider.ppc(shard)
                .deleteFrom(Tables.ESS_ADDITIONAL_OBJECTS)
                .limit(DELETE_CHUNK_SIZE)
                .execute()
        } while (deletedRows >= DELETE_CHUNK_SIZE)
    }
}
