package ru.yandex.direct.excel.processing.configuration;

import java.io.File;
import java.util.UUID;

import javax.annotation.PostConstruct;

import org.apache.poi.util.DefaultTempFileCreationStrategy;
import org.apache.poi.util.TempFile;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.core.configuration.CoreConfiguration;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.AdGroupAdditionalTargetingService;
import ru.yandex.direct.core.entity.banner.service.BannerService;
import ru.yandex.direct.core.entity.campaign.service.CampaignService;
import ru.yandex.direct.core.entity.client.service.ClientGeoService;
import ru.yandex.direct.core.entity.image.service.ImageService;
import ru.yandex.direct.core.entity.internalads.service.TemplateInfoService;
import ru.yandex.direct.core.entity.internalads.service.TemplatePlaceService;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionService;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingService;
import ru.yandex.direct.env.Environment;
import ru.yandex.direct.excel.processing.service.actreport.ActReportExcelExportService;
import ru.yandex.direct.excel.processing.service.brandsafety.BrandSafetyStatsExcelExportService;
import ru.yandex.direct.excel.processing.service.internalad.AddExcelValidationDataService;
import ru.yandex.direct.excel.processing.service.internalad.CryptaSegmentDictionariesService;
import ru.yandex.direct.excel.processing.service.internalad.InternalAdExcelService;
import ru.yandex.direct.excel.processing.service.internalad.InternalAdExcelValidationService;

import static org.apache.poi.util.TempFile.JAVA_IO_TMPDIR;

@Configuration
@Import({CoreConfiguration.class})
@ComponentScan(
        basePackages = "ru.yandex.direct.excel.processing",
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
public class ExcelProcessingConfiguration {

    @Lazy
    @Bean
    public InternalAdExcelValidationService excelValidationService(CampaignService campaignService,
                                                                   TemplatePlaceService templatePlaceService,
                                                                   TemplateInfoService templateInfoService) {
        return new InternalAdExcelValidationService(campaignService, templatePlaceService, templateInfoService);
    }

    @Lazy
    @Bean
    public InternalAdExcelService excelService(CampaignService campaignService, AdGroupService adGroupService,
                                               AdGroupAdditionalTargetingService adGroupAdditionalTargetingService,
                                               BannerService bannerService, ImageService imageService,
                                               TemplateInfoService templateInfoService,
                                               ClientGeoService clientGeoService,
                                               CryptaSegmentDictionariesService cryptaSegmentDictionariesService,
                                               AddExcelValidationDataService addExcelValidationDataService,
                                               RetargetingConditionService retargetingConditionService,
                                               RetargetingService retargetingService,
                                               InternalAdExcelValidationService internalAdExcelValidationService) {
        return new InternalAdExcelService(campaignService, adGroupService, adGroupAdditionalTargetingService,
                bannerService, imageService, templateInfoService, clientGeoService,
                cryptaSegmentDictionariesService, addExcelValidationDataService, retargetingConditionService,
                retargetingService, internalAdExcelValidationService);
    }

    @Lazy
    @Bean
    public BrandSafetyStatsExcelExportService brandSafetyStatsExcelExportService(){
        return new BrandSafetyStatsExcelExportService();
    }

    @Lazy
    @Bean
    public ActReportExcelExportService actReportExcelExportService() {
        return new ActReportExcelExportService();
    }

    /**
     * По умолчанию Apache POI использует директорию {@code /tmp/poifiles} для
     * создания временных файлов. Если в одном окружении несколько пользователей
     * будут создавать свои приложения, использующие Apache POI, то возникнет проблема
     * с правами на эту директорию — её создаст первый пользователь с правами на запись
     * только для себя (как владельца), а остальные получат ошибку Permissions denied.
     * Поэтому для бета-окружений устанавливаем свою временную директорию для каждого
     * приложения.
     *
     * @see TempFile
     * @see DefaultTempFileCreationStrategy
     */
    @PostConstruct
    private void setUpPoiTemporaryFilesDirectory() {
        if (!Environment.getCached().isBeta()) {
            return;
        }
        if (System.getProperty(JAVA_IO_TMPDIR) == null) {
            throw new IllegalStateException("Не указана директория для временных файлов");
        }
        String tmpBaseDir = System.getProperty(JAVA_IO_TMPDIR);
        String currentAppTmpSubdir = UUID.randomUUID().toString();
        File tmpDir = new File(tmpBaseDir, currentAppTmpSubdir);
        tmpDir.deleteOnExit(); // Удалим директорию при завершении приложения
        TempFile.setTempFileCreationStrategy(new DefaultTempFileCreationStrategy(tmpDir));
    }

}
