package ru.yandex.direct.excel.processing.exception;

import java.util.Objects;

import org.apache.commons.lang3.builder.ToStringBuilder;

import ru.yandex.direct.validation.result.DefectId;
import ru.yandex.direct.validation.result.Path;

import static ru.yandex.direct.validation.result.PathHelper.path;

public class ExcelValidationException extends RuntimeException {

    private final DefectId defectId;
    private final Path path;
    private final Object params;

    public DefectId getDefectId() {
        return defectId;
    }

    public Path getPath() {
        return path;
    }

    public Object getParams() {
        return params;
    }

    private ExcelValidationException(DefectId defectId, Path path, Object params) {
        this.defectId = defectId;
        this.path = path;
        this.params = params;
    }

    public static ExcelValidationException create(DefectId defectId) {
        return create(defectId, path());
    }

    public static ExcelValidationException create(DefectId defectId, Path path) {
        return create(defectId, path, null);
    }

    public static ExcelValidationException create(DefectId defectId, Object params) {
        return new ExcelValidationException(defectId, path(), params);
    }

    public static ExcelValidationException create(DefectId defectId, Path path, Object params) {
        return new ExcelValidationException(defectId, path, params);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExcelValidationException that = (ExcelValidationException) o;
        return Objects.equals(defectId, that.defectId) &&
                Objects.equals(path, that.path) &&
                Objects.equals(params, that.params);
    }

    @Override
    public int hashCode() {
        return Objects.hash(defectId, path, params);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("defectId", defectId)
                .append("path", path)
                .append("params", params)
                .toString();
    }

}
