package ru.yandex.direct.excel.processing.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.collections4.CollectionUtils;

import static com.google.common.base.Preconditions.checkState;

@ParametersAreNonnullByDefault
public class ColumnsWithChoices {

    private static final List<String> YES_OR_NO_CHOICES = List.of("Да", "Нет");
    private static final List<String> READ_ONLY = List.of("Ячейка только для чтения");

    private final Set<String> columnTitles;
    private final Collection<String> choices;

    public ColumnsWithChoices(Set<String> columnTitles, Collection<String> choices) {
        checkState(CollectionUtils.isNotEmpty(columnTitles), "column titles must be not empty");
        checkState(CollectionUtils.isNotEmpty(choices), "column choices must be not empty");
        this.columnTitles = columnTitles;
        this.choices = choices;
    }

    public Set<String> getColumnTitles() {
        return columnTitles;
    }

    public Collection<String> getChoices() {
        return choices;
    }

    public static ColumnsWithChoicesListBuilder listBuilder() {
        return new ColumnsWithChoicesListBuilder();
    }

    public static class ColumnsWithChoicesListBuilder {

        private final List<ColumnsWithChoices> columnTitlesWithChoices;

        public ColumnsWithChoicesListBuilder() {
            this.columnTitlesWithChoices = new ArrayList<>();
        }

        public <T> ColumnsWithChoicesListBuilder addColumnsWithYesOrNoChoices(Set<String> columnTitles) {
            return addColumnTitlesWithChoices(columnTitles, YES_OR_NO_CHOICES);
        }

        public <T> ColumnsWithChoicesListBuilder addReadOnlyColumns(Set<String> columnTitles) {
            return addColumnTitlesWithChoices(columnTitles, READ_ONLY);
        }

        public ColumnsWithChoicesListBuilder addColumnTitlesWithChoices(Set<String> columnTitles,
                                                                        Collection<String> choices) {
            columnTitlesWithChoices.add(new ColumnsWithChoices(columnTitles, choices));
            return this;
        }

        public List<ColumnsWithChoices> build() {
            return List.copyOf(columnTitlesWithChoices);
        }

    }
}
