package ru.yandex.direct.excel.processing.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Модель для хранения значения таргетинга с версиями прочитанного из excel файла
 */
@ParametersAreNonnullByDefault
public class VersionedTargetingInfo {

    private String value;
    private String minVersion;
    private String maxVersion;

    public String getValue() {
        return value;
    }

    public VersionedTargetingInfo withValue(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    public String getMinVersion() {
        return minVersion;
    }

    public VersionedTargetingInfo withMinVersion(@Nullable String minVersion) {
        this.minVersion = minVersion;
        return this;
    }

    @Nullable
    public String getMaxVersion() {
        return maxVersion;
    }

    public VersionedTargetingInfo withMaxVersion(@Nullable String maxVersion) {
        this.maxVersion = maxVersion;
        return this;
    }

}
