package ru.yandex.direct.excel.processing.model.brandsafety;

import java.time.LocalDate;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class BrandSafetyStatsExcelExportData {
    private LocalDate startDate;

    private LocalDate endDate;

    private Boolean showCampaigns;

    private Boolean showCategories;

    private BrandSafetyStatsExcelExportLanguage language;

    private String userName;

    private String userLogin;

    private Double total;

    private List<BrandSafetyStatsExcelExportRow> rows;

    public LocalDate getStartDate() {
        return startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public BrandSafetyStatsExcelExportData withStartDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    public LocalDate getEndDate() {
        return endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public BrandSafetyStatsExcelExportData withEndDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    public Boolean getShowCampaigns() {
        return showCampaigns;
    }

    public void setShowCampaigns(Boolean showCampaigns) {
        this.showCampaigns = showCampaigns;
    }

    public BrandSafetyStatsExcelExportData withShowCampaigns(Boolean showCampaigns) {
        this.showCampaigns = showCampaigns;
        return this;
    }

    public Boolean getShowCategories() {
        return showCategories;
    }

    public void setShowCategories(Boolean showCategories) {
        this.showCategories = showCategories;
    }

    public BrandSafetyStatsExcelExportData withShowCategories(Boolean showCategories) {
        this.showCategories = showCategories;
        return this;
    }

    public BrandSafetyStatsExcelExportLanguage getLanguage() {
        return language;
    }

    public void setLanguage(BrandSafetyStatsExcelExportLanguage language) {
        this.language = language;
    }

    public BrandSafetyStatsExcelExportData withLanguage(BrandSafetyStatsExcelExportLanguage language) {
        this.language = language;
        return this;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public BrandSafetyStatsExcelExportData withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getUserLogin() {
        return userLogin;
    }

    public void setUserLogin(String userLogin) {
        this.userLogin = userLogin;
    }

    public BrandSafetyStatsExcelExportData withUserLogin(String userLogin) {
        this.userLogin = userLogin;
        return this;
    }

    public Double getTotal() {
        return total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public BrandSafetyStatsExcelExportData withTotal(Double total) {
        this.total = total;
        return this;
    }

    public List<BrandSafetyStatsExcelExportRow> getRows() {
        return rows;
    }

    public void setRows(List<BrandSafetyStatsExcelExportRow> rows) {
        this.rows = rows;
    }

    public BrandSafetyStatsExcelExportData withRows(List<BrandSafetyStatsExcelExportRow> rows) {
        this.rows = rows;
        return this;
    }
}
