package ru.yandex.direct.excel.processing.model.internalad;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkArgument;

@ParametersAreNonnullByDefault
public class CryptaSegment {

    private final String keywordId;
    private final String segmentId;

    private CryptaSegment(String keywordId, String segmentId) {
        //noinspection ConstantConditions
        checkArgument(keywordId != null, "keywordId must not be null");
        //noinspection ConstantConditions
        checkArgument(segmentId != null, "segmentId must not be null");
        this.keywordId = keywordId;
        this.segmentId = segmentId;
    }

    public static CryptaSegment create(String keywordId, String segmentId) {
        return new CryptaSegment(keywordId, segmentId);
    }

    public String getKeywordId() {
        return keywordId;
    }

    public String getSegmentId() {
        return segmentId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CryptaSegment that = (CryptaSegment) o;
        return Objects.equals(keywordId, that.keywordId) &&
                Objects.equals(segmentId, that.segmentId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(keywordId, segmentId);
    }

}
