package ru.yandex.direct.excel.processing.model.internalad;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Параметры объектов полученных из всех листов excel файла
 */
@ParametersAreNonnullByDefault
public class ExcelFetchedData {

    public static final String AD_GROUPS_PATH = "adGroups";
    public static final String RETARGETING_CONDITIONS = "retargetingConditions";
    public static final String ADS_PATH = "ads";

    private final ExcelSheetFetchedData<InternalAdGroupRepresentation> adGroupsSheet;
    private final List<ExcelSheetFetchedData<InternalBannerRepresentation>> adsSheets;

    private ExcelFetchedData(ExcelSheetFetchedData<InternalAdGroupRepresentation> adGroupsSheet,
                             List<ExcelSheetFetchedData<InternalBannerRepresentation>> adsSheets) {
        this.adGroupsSheet = adGroupsSheet;
        this.adsSheets = adsSheets;
    }

    public static ExcelFetchedData create(ExcelSheetFetchedData<InternalAdGroupRepresentation> adGroupsSheet,
                                          List<ExcelSheetFetchedData<InternalBannerRepresentation>> adsSheets) {
        return new ExcelFetchedData(adGroupsSheet, adsSheets);
    }

    public ExcelSheetFetchedData<InternalAdGroupRepresentation> getAdGroupsSheet() {
        return adGroupsSheet;
    }

    public List<ExcelSheetFetchedData<InternalBannerRepresentation>> getAdsSheets() {
        return adsSheets;
    }

}
