package ru.yandex.direct.excel.processing.model.internalad;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.validation.ValidationUtils;
import ru.yandex.direct.result.MassResult;

@ParametersAreNonnullByDefault
public class ExcelImportResult {

    private MassResult<Long> adGroupsResult;
    private MassResult<Long> adsResult;
    private String excelFileUrl;

    public MassResult<Long> getAdGroupsResult() {
        return adGroupsResult;
    }

    public ExcelImportResult withAdGroupsResult(MassResult<Long> adGroupsResult) {
        this.adGroupsResult = adGroupsResult;
        return this;
    }

    public MassResult<Long> getAdsResult() {
        return adsResult;
    }

    public ExcelImportResult withAdsResult(MassResult<Long> adsResult) {
        this.adsResult = adsResult;
        return this;
    }

    public String getExcelFileUrl() {
        return excelFileUrl;
    }

    public ExcelImportResult withExcelFileUrl(String excelFileUrl) {
        this.excelFileUrl = excelFileUrl;
        return this;
    }

    public boolean hasValidationIssues() {
        return ValidationUtils.hasValidationIssues(this.adGroupsResult)
                || ValidationUtils.hasValidationIssues(this.adsResult);
    }

}
