package ru.yandex.direct.excel.processing.model.internalad;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Параметры объектов полученных из одного листа excel файла
 */
@ParametersAreNonnullByDefault
public class ExcelSheetFetchedData<T> {

    private final String sheetName;
    private final SheetDescriptor sheetDescriptor;
    private final List<T> objects;
    private final List<String> fetchedColumnTitles;
    private final List<String> mappersColumnTitles;

    private ExcelSheetFetchedData(String sheetName, SheetDescriptor sheetDescriptor, List<T> objects,
                                  List<String> fetchedColumnTitles, List<String> mappersColumnTitles) {
        this.sheetName = sheetName;
        this.sheetDescriptor = sheetDescriptor;
        this.objects = objects;
        this.fetchedColumnTitles = fetchedColumnTitles;
        this.mappersColumnTitles = mappersColumnTitles;
    }

    public static <T> ExcelSheetFetchedData<T> create(String sheetName, SheetDescriptor sheetDescriptor,
                                                      List<T> objects,
                                                      List<String> actualColumnTitles,
                                                      List<String> expectedColumnTitles) {
        return new ExcelSheetFetchedData<>(sheetName, sheetDescriptor, objects,
                actualColumnTitles, expectedColumnTitles);
    }

    public String getSheetName() {
        return sheetName;
    }

    public SheetDescriptor getSheetDescriptor() {
        return sheetDescriptor;
    }

    public List<T> getObjects() {
        return objects;
    }

    public List<String> getFetchedColumnTitles() {
        return fetchedColumnTitles;
    }

    public List<String> getMappersColumnTitles() {
        return mappersColumnTitles;
    }

}
