package ru.yandex.direct.excel.processing.model.internalad;

import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.model.ClientId;

@ParametersAreNonnullByDefault
public class InternalAdExportParameters {

    private ClientId clientId;
    private boolean exportAdGroupsWithAds;
    private boolean hideEmptyColumns;

    /**
     * Ожидается, что будет заполнено только одно из полей с id'шниками.
     */
    private Set<Long> campaignIds;
    private Set<Long> adGroupIds;
    private Set<Long> adIds;

    @Nonnull
    public ClientId getClientId() {
        return clientId;
    }

    public InternalAdExportParameters withClientId(ClientId clientId) {
        this.clientId = clientId;
        return this;
    }

    public boolean isExportAdGroupsWithAds() {
        return exportAdGroupsWithAds;
    }

    public InternalAdExportParameters withExportAdGroupsWithAds(boolean exportOnlyAdGroups) {
        this.exportAdGroupsWithAds = exportOnlyAdGroups;
        return this;
    }

    @Nullable
    public Set<Long> getCampaignIds() {
        return campaignIds;
    }

    public InternalAdExportParameters withCampaignIds(@Nullable Set<Long> campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    @Nullable
    public Set<Long> getAdGroupIds() {
        return adGroupIds;
    }

    public InternalAdExportParameters withAdGroupIds(@Nullable Set<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
        return this;
    }

    @Nullable
    public Set<Long> getAdIds() {
        return adIds;
    }

    public InternalAdExportParameters withAdIds(@Nullable Set<Long> adIds) {
        this.adIds = adIds;
        return this;
    }

    public boolean isHideEmptyColumns() {
        return hideEmptyColumns;
    }

    public InternalAdExportParameters withHideEmptyColumns(boolean hideEmptyColumns) {
        this.hideEmptyColumns = hideEmptyColumns;
        return this;
    }
}
