package ru.yandex.direct.excel.processing.model.internalad;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.InternalAdGroup;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants;

import static ru.yandex.direct.utils.FunctionalUtils.filterAndMapList;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class InternalAdGroupRepresentation {
    private InternalAdGroup adGroup;
    private AdGroupAdditionalTargetingRepresentation targetingRepresentation;
    private RetargetingConditionRepresentation retargetingConditionRepresentation;

    public InternalAdGroup getAdGroup() {
        return adGroup;
    }

    public InternalAdGroupRepresentation setAdGroup(InternalAdGroup adGroup) {
        this.adGroup = adGroup;
        return this;
    }

    public AdGroupAdditionalTargetingRepresentation getTargetingRepresentation() {
        return targetingRepresentation;
    }

    public InternalAdGroupRepresentation setTargetingRepresentation(AdGroupAdditionalTargetingRepresentation targetingRepresentation) {
        this.targetingRepresentation = targetingRepresentation;
        return this;
    }

    public RetargetingConditionRepresentation getRetargetingConditionRepresentation() {
        return retargetingConditionRepresentation;
    }

    public InternalAdGroupRepresentation setRetargetingConditionRepresentation(RetargetingConditionRepresentation retargetingConditionRepresentation) {
        this.retargetingConditionRepresentation = retargetingConditionRepresentation;
        return this;
    }


    private List<Long> getAdGroupGeo() {
        if (adGroup.getGeo() == null) {
            adGroup.setGeo(new ArrayList<>());
        }

        return adGroup.getGeo();
    }

    public List<Long> getGeoIncluded() {
        return filterList(adGroup.getGeo(), id -> id >= 0);
    }

    public void setGeoIncluded(List<Long> geoIncluded) {
        getAdGroupGeo().addAll(geoIncluded);
    }

    public List<Long> getGeoExcluded() {
        return filterAndMapList(adGroup.getGeo(), id -> id < 0, id -> -id);
    }

    public void setGeoExcluded(List<Long> geoExcluded) {
        geoExcluded = mapList(geoExcluded, id -> -id);
        getAdGroupGeo().addAll(geoExcluded);
    }

    public Integer getMaxClicksCount() {
        return adGroup.getMaxClicksCount();
    }

    public void setMaxClicksCount(Integer maxClicksCount) {
        adGroup.setMaxClicksCount(maxClicksCount);
    }

    public Integer getMaxClicksPeriod() {
        var maxClicksPeriod = adGroup.getMaxClicksPeriod();
        if (maxClicksPeriod != null && maxClicksPeriod != CampaignConstants.MAX_CLICKS_AND_STOPS_PERIOD_WHOLE_CAMPAIGN_VALUE) {
            return maxClicksPeriod;
        } else {
            return null;
        }
    }

    public void setMaxClicksPeriod(@Nullable Integer maxClicksPeriod) {
        if (maxClicksPeriod == null && getMaxClicksCount() != null) {
            // Если null у значения периода означает "весь срок кампании"
            adGroup.setMaxClicksPeriod(CampaignConstants.MAX_CLICKS_AND_STOPS_PERIOD_WHOLE_CAMPAIGN_VALUE);
        } else {
            adGroup.setMaxClicksPeriod(maxClicksPeriod);
        }
    }

    public Integer getMaxStopsCount() {
        return adGroup.getMaxStopsCount();
    }

    public void setMaxStopsCount(Integer maxStopsCount) {
        adGroup.setMaxStopsCount(maxStopsCount);
    }

    public Integer getMaxStopsPeriod() {
        var maxStopsPeriod = adGroup.getMaxStopsPeriod();
        if (maxStopsPeriod != null && maxStopsPeriod != CampaignConstants.MAX_CLICKS_AND_STOPS_PERIOD_WHOLE_CAMPAIGN_VALUE) {
            return maxStopsPeriod;
        } else {
            return null;
        }
    }

    public void setMaxStopsPeriod(@Nullable Integer maxStopsPeriod) {
        if (maxStopsPeriod == null && getMaxStopsCount() != null) {
            // Если null у значения периода означает "весь срок кампании"
            adGroup.setMaxStopsPeriod(CampaignConstants.MAX_CLICKS_AND_STOPS_PERIOD_WHOLE_CAMPAIGN_VALUE);
        } else {
            adGroup.setMaxStopsPeriod(maxStopsPeriod);
        }
    }
}
