package ru.yandex.direct.excel.processing.model.internalad;

import java.util.ArrayList;
import java.util.Collections;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.banner.model.InternalBanner;
import ru.yandex.direct.core.entity.banner.model.InternalModerationInfo;
import ru.yandex.direct.core.entity.banner.model.TemplateVariable;

@ParametersAreNonnullByDefault
public class InternalBannerRepresentation {

    private String adGroupName;
    @Nullable
    private Long adGroupId;
    private InternalBanner banner;

    @Nullable
    public Long getAdGroupId() {
        return adGroupId;
    }

    public InternalBannerRepresentation setAdGroupId(@Nullable Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public String getAdGroupName() {
        return adGroupName;
    }

    public InternalBannerRepresentation setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
        return this;
    }

    public InternalBanner getBanner() {
        if (banner.getAdGroupId() == null) {
            banner.setAdGroupId(getAdGroupId());
        }
        if (banner.getTemplateVariables() == null) {
            banner.setTemplateVariables(Collections.emptyList());
        }
        return banner;
    }

    public InternalBannerRepresentation setBanner(InternalBanner banner) {
        this.banner = banner;
        if (this.adGroupId == null) {
            setAdGroupId(banner.getAdGroupId());
        }
        return this;
    }

    @Nullable
    public String getTemplateVariableValue(Long templateResourceId) {
        return StreamEx.of(banner.getTemplateVariables())
                .filter(variable -> templateResourceId.equals(variable.getTemplateResourceId()))
                .findFirst()
                .map(TemplateVariable::getInternalValue)
                .orElse(null);
    }

    public void setTemplateVariableValue(Long templateResourceId, @Nullable String value) {
        if (banner.getTemplateVariables() == null) {
            banner.setTemplateVariables(new ArrayList<>());
        }

        banner.getTemplateVariables().add(new TemplateVariable()
                .withTemplateResourceId(templateResourceId)
                .withInternalValue(value));
    }

    @Nullable
    public InternalModerationInfo getModerationInfo() {
        return banner.getModerationInfo();
    }

    public void setModerationInfo(@Nullable InternalModerationInfo moderationInfo) {
        banner.setModerationInfo(moderationInfo);
    }

}
