package ru.yandex.direct.excel.processing.model.internalad;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class VersionedTargetingRepresentation {

    /**
     * Ожидается, что будет заполнено только одно value.
     */
    @Nullable
    private String positiveValue;

    @Nullable
    private String negativeValue;

    @Nullable
    private String minVersion;

    @Nullable
    private String maxVersion;

    public String getPositiveValue() {
        return positiveValue;
    }

    public VersionedTargetingRepresentation setPositiveValue(String positiveValue) {
        this.positiveValue = positiveValue;
        return this;
    }

    public String getNegativeValue() {
        return negativeValue;
    }

    public VersionedTargetingRepresentation setNegativeValue(String negativeValue) {
        this.negativeValue = negativeValue;
        return this;
    }

    @Nullable
    public String getMinVersion() {
        return minVersion;
    }

    public VersionedTargetingRepresentation setMinVersion(@Nullable String minVersion) {
        this.minVersion = minVersion;
        return this;
    }

    @Nullable
    public String getMaxVersion() {
        return maxVersion;
    }

    public VersionedTargetingRepresentation setMaxVersion(@Nullable String maxVersion) {
        this.maxVersion = maxVersion;
        return this;
    }
}
