package ru.yandex.direct.excel.processing.model.internalad.mappers;

import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.DistribSoftConstants;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.UaTraitsConstants;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.CallerReferrersAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidTypesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.DesktopInstalledAppsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.DeviceIdsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.FeaturesInPPAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasLCookieAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasPassportIdAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InterfaceLang;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InterfaceLangsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InternalNetworkAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsDefaultYandexSearchAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsPPLoggedInAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsVirusedAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsYandexPlusAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.MobileInstalledAppsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.PlusUserSegmentsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryOptionsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryReferersAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.SearchTextAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ShowDatesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.SidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.TestIdsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UserAgentsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UuidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexUidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexuidAgeAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YpCookiesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YsCookiesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserEngine;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserEnginesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserName;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceVendor;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceVendorsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsMobileAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsTabletAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsTouchAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsFamiliesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsFamily;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsName;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.UatraitsTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.VersionedTargeting;
import ru.yandex.direct.excel.processing.model.internalad.AdGroupAdditionalTargetingRepresentation;
import ru.yandex.direct.excel.processing.model.internalad.VersionedTargetingRepresentation;
import ru.yandex.direct.excelmapper.ExcelMapper;
import ru.yandex.direct.excelmapper.mappers.ObjectExcelMapper;
import ru.yandex.direct.model.ModelProperty;

import static ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargetingJoinType.ALL;
import static ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargetingJoinType.ANY;
import static ru.yandex.direct.excel.processing.model.internalad.mappers.AdGroupAdditionalTargetingMapperSettings.getAllDoneTargetingTitle;
import static ru.yandex.direct.excel.processing.model.internalad.mappers.AdGroupAdditionalTargetingMapperSettings.getNegativeTargetingTitle;
import static ru.yandex.direct.excel.processing.model.internalad.mappers.AdGroupAdditionalTargetingMapperSettings.getTargetingTitle;
import static ru.yandex.direct.excelmapper.ExcelMappers.enumMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.localDateMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.longMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.maybeIntMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.maybeListMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.maybePredicateCheckingMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.maybeSetMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.maybeStringMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.maybeYesNoBooleanMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.objectMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.predicateCheckingMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.stringMapper;

@ParametersAreNonnullByDefault
public class AdGroupAdditionalTargetingMapper {

    private AdGroupAdditionalTargetingMapper() {
    }

    static final ExcelMapper<AdGroupAdditionalTargetingRepresentation> AD_GROUP_TARGETING_MAPPER =
            getAdGroupTargetingMapper();

    private static ExcelMapper<AdGroupAdditionalTargetingRepresentation> getAdGroupTargetingMapper() {
        var builder = objectMapper(AdGroupAdditionalTargetingRepresentation::new);
        addTargetingWithSetOfDateValueMapper(builder, ShowDatesAdGroupAdditionalTargeting::new,
                ShowDatesAdGroupAdditionalTargeting.VALUE);

        String interfaceLangsTargetingTitle = getTargetingTitle(InterfaceLangsAdGroupAdditionalTargeting.class);
        builder
                .field(AdGroupAdditionalTargetingRepresentation::getInternalNetworkAdGroupAdditionalTargeting,
                        AdGroupAdditionalTargetingRepresentation::setInternalNetworkAdGroupAdditionalTargeting,
                        maybeYesNoBooleanMapper(getTargetingTitle(InternalNetworkAdGroupAdditionalTargeting.class)))
                .field(AdGroupAdditionalTargetingRepresentation::getInterfaceLangsAdGroupAdditionalTargetingTargeting,
                        AdGroupAdditionalTargetingRepresentation::setInterfaceLangsAdGroupAdditionalTargetingTargeting,
                        maybeSetMapper(enumMapper(interfaceLangsTargetingTitle,
                                InterfaceLang::getTypedValue, AdGroupAdditionalTargetingMapper::toInterfaceLang)))
                .field(AdGroupAdditionalTargetingRepresentation::getInterfaceLangsAdGroupAdditionalTargetingFiltering,
                        AdGroupAdditionalTargetingRepresentation::setInterfaceLangsAdGroupAdditionalTargetingFiltering,
                        maybeSetMapper(enumMapper(getNegativeTargetingTitle(interfaceLangsTargetingTitle),
                                InterfaceLang::getTypedValue, AdGroupAdditionalTargetingMapper::toInterfaceLang)));
        addTargetingWithListOfStringsValueMapper(builder, QueryReferersAdGroupAdditionalTargeting::new,
                QueryReferersAdGroupAdditionalTargeting.VALUE);
        addTargetingWithListOfStringsValueMapper(builder, CallerReferrersAdGroupAdditionalTargeting::new,
                CallerReferrersAdGroupAdditionalTargeting.VALUE);
        addTargetingWithListOfStringsValueMapper(builder, UserAgentsAdGroupAdditionalTargeting::new,
                UserAgentsAdGroupAdditionalTargeting.VALUE);
        addDesktopTargetingMapper(builder, DesktopInstalledAppsAdGroupAdditionalTargeting::new,
                DesktopInstalledAppsAdGroupAdditionalTargeting.VALUE, DistribSoftConstants.DISTRIB_SOFT);
        addMobileAppTargetingMapper(builder);
        addTargetingWithSetOfStringsValueMapper(builder, YsCookiesAdGroupAdditionalTargeting::new,
                YsCookiesAdGroupAdditionalTargeting.VALUE);
        addTargetingWithSetOfLongValueMapper(builder, ClidsAdGroupAdditionalTargeting::new,
                ClidsAdGroupAdditionalTargeting.VALUE);
        addTargetingWithSetOfLongValueMapper(builder, ClidTypesAdGroupAdditionalTargeting::new,
                ClidTypesAdGroupAdditionalTargeting.VALUE);
        addTargetingWithListOfStringsValueMapper(builder, YandexUidsAdGroupAdditionalTargeting::new,
                YandexUidsAdGroupAdditionalTargeting.VALUE);
        addTargetingWithSetOfLongValueMapper(builder, TestIdsAdGroupAdditionalTargeting::new,
                TestIdsAdGroupAdditionalTargeting.VALUE);
        addUatraitsTargetingMapper(builder, DeviceVendorsAdGroupAdditionalTargeting::new, DeviceVendor::new,
                DeviceVendorsAdGroupAdditionalTargeting.VALUE, UaTraitsConstants.DEVICE_VENDOR);
        addTargetingWithListOfStringsValueMapper(builder, DeviceNamesAdGroupAdditionalTargeting::new,
                DeviceNamesAdGroupAdditionalTargeting.VALUE);

        builder
                .field(AdGroupAdditionalTargetingRepresentation::getIsMobileAdGroupAdditionalTargeting,
                        AdGroupAdditionalTargetingRepresentation::setIsMobileAdGroupAdditionalTargeting,
                        maybeYesNoBooleanMapper(getTargetingTitle(IsMobileAdGroupAdditionalTargeting.class)))
                .field(AdGroupAdditionalTargetingRepresentation::getIsTabletAdGroupAdditionalTargeting,
                        AdGroupAdditionalTargetingRepresentation::setIsTabletAdGroupAdditionalTargeting,
                        maybeYesNoBooleanMapper(getTargetingTitle(IsTabletAdGroupAdditionalTargeting.class)))
                .field(AdGroupAdditionalTargetingRepresentation::getIsTouchAdGroupAdditionalTargeting,
                        AdGroupAdditionalTargetingRepresentation::setIsTouchAdGroupAdditionalTargeting,
                        maybeYesNoBooleanMapper(getTargetingTitle(IsTouchAdGroupAdditionalTargeting.class)));
        addVersionedTargetingMapper(builder, OsFamiliesAdGroupAdditionalTargeting::new, OsFamily::new,
                OsFamiliesAdGroupAdditionalTargeting.VALUE, UaTraitsConstants.OS_FAMILY);
        addUatraitsTargetingMapper(builder, OsNamesAdGroupAdditionalTargeting::new, OsName::new,
                OsNamesAdGroupAdditionalTargeting.VALUE, UaTraitsConstants.OS_NAME);
        addVersionedTargetingMapper(builder, BrowserEnginesAdGroupAdditionalTargeting::new, BrowserEngine::new,
                BrowserEnginesAdGroupAdditionalTargeting.VALUE, UaTraitsConstants.BROWSER_ENGINE);
        addVersionedTargetingMapper(builder, BrowserNamesAdGroupAdditionalTargeting::new, BrowserName::new,
                BrowserNamesAdGroupAdditionalTargeting.VALUE, UaTraitsConstants.BROWSER_NAME);
        addTargetingWithSetOfStringsValueMapper(builder, QueryOptionsAdGroupAdditionalTargeting::new,
                QueryOptionsAdGroupAdditionalTargeting.VALUE);

        builder
                .field(AdGroupAdditionalTargetingRepresentation::getIsYandexPlusAdGroupAdditionalTargeting,
                        AdGroupAdditionalTargetingRepresentation::setIsYandexPlusAdGroupAdditionalTargeting,
                        maybeYesNoBooleanMapper(getTargetingTitle(IsYandexPlusAdGroupAdditionalTargeting.class)))
                .field(AdGroupAdditionalTargetingRepresentation::getIsVirusedAdGroupAdditionalTargeting,
                        AdGroupAdditionalTargetingRepresentation::setIsVirusedAdGroupAdditionalTargeting,
                        maybeYesNoBooleanMapper(getTargetingTitle(IsVirusedAdGroupAdditionalTargeting.class)))
                .field(AdGroupAdditionalTargetingRepresentation::getHasLCookieAdGroupAdditionalTargeting,
                        AdGroupAdditionalTargetingRepresentation::setHasLCookieAdGroupAdditionalTargeting,
                        maybeYesNoBooleanMapper(getTargetingTitle(HasLCookieAdGroupAdditionalTargeting.class)))
                .field(AdGroupAdditionalTargetingRepresentation::getHasPassportIdAdGroupAdditionalTargeting,
                        AdGroupAdditionalTargetingRepresentation::setHasPassportIdAdGroupAdditionalTargeting,
                        maybeYesNoBooleanMapper(getTargetingTitle(HasPassportIdAdGroupAdditionalTargeting.class)))
                .field(AdGroupAdditionalTargetingRepresentation::getIsDefaultYandexSearchAdGroupAdditionalTargeting,
                        AdGroupAdditionalTargetingRepresentation::setIsDefaultYandexSearchAdGroupAdditionalTargeting,
                        maybeYesNoBooleanMapper(getTargetingTitle(IsDefaultYandexSearchAdGroupAdditionalTargeting.class)))
                .field(AdGroupAdditionalTargetingRepresentation::getIsPPLoggedInAdGroupAdditionalTargeting,
                        AdGroupAdditionalTargetingRepresentation::setIsPPLoggedInAdGroupAdditionalTargeting,
                        maybeYesNoBooleanMapper(getTargetingTitle(IsPPLoggedInAdGroupAdditionalTargeting.class)));

        addTargetingWithSetOfStringsValueMapper(builder, FeaturesInPPAdGroupAdditionalTargeting::new,
                FeaturesInPPAdGroupAdditionalTargeting.VALUE);
        addTargetingWithSetOfStringsValueMapper(builder, YpCookiesAdGroupAdditionalTargeting::new,
                YpCookiesAdGroupAdditionalTargeting.VALUE);
        addTargetingWithSetOfLongValueMapper(builder, SidsAdGroupAdditionalTargeting::new,
                SidsAdGroupAdditionalTargeting.VALUE);
        addTargetingWithSetOfStringsValueMapper(builder, UuidsAdGroupAdditionalTargeting::new,
                UuidsAdGroupAdditionalTargeting.VALUE);
        addTargetingWithSetOfStringsValueMapper(builder, DeviceIdsAdGroupAdditionalTargeting::new,
                DeviceIdsAdGroupAdditionalTargeting.VALUE);
        addTargetingWithSetOfLongValueMapper(builder, PlusUserSegmentsAdGroupAdditionalTargeting::new,
                PlusUserSegmentsAdGroupAdditionalTargeting.VALUE);
        addTargetingWithSetOfStringsValueMapper(builder, SearchTextAdGroupAdditionalTargeting::new,
                SearchTextAdGroupAdditionalTargeting.VALUE);

        addYandexuidAgeAdditionalTargetingMapper(builder);

        return builder.build();
    }

    private static void addYandexuidAgeAdditionalTargetingMapper(
            ObjectExcelMapper.ObjectExcelMapperBuilder<AdGroupAdditionalTargetingRepresentation> builder) {
        String title = getTargetingTitle(YandexuidAgeAdGroupAdditionalTargeting.class);

        builder
                //targeting
                .field(r -> r.getAdditionalTargetingValue(YandexuidAgeAdGroupAdditionalTargeting.VALUE, true),
                        (r, value) -> r.setAdditionalTargetingValue(
                                YandexuidAgeAdGroupAdditionalTargeting::new,
                                YandexuidAgeAdGroupAdditionalTargeting.VALUE,
                                true, value), maybeIntMapper(title + " >="))
                //filtering
                .field(r -> r.getAdditionalTargetingValue(YandexuidAgeAdGroupAdditionalTargeting.VALUE, false),
                        (r, value) -> r.setAdditionalTargetingValue(
                                YandexuidAgeAdGroupAdditionalTargeting::new,
                                YandexuidAgeAdGroupAdditionalTargeting.VALUE,
                                false, value), maybeIntMapper(title + " <="));
    }

    private static <T extends AdGroupAdditionalTargeting> void addTargetingWithSetOfLongValueMapper(
            ObjectExcelMapper.ObjectExcelMapperBuilder<AdGroupAdditionalTargetingRepresentation> builder,
            Supplier<T> constructor, ModelProperty<T, Set<Long>> valueModelProperty) {
        addTargetingCollectionValueMapper(builder, constructor, valueModelProperty,
                columnTitle -> maybeSetMapper(longMapper(columnTitle)));
    }

    private static <T extends AdGroupAdditionalTargeting> void addTargetingWithSetOfStringsValueMapper(
            ObjectExcelMapper.ObjectExcelMapperBuilder<AdGroupAdditionalTargetingRepresentation> builder,
            Supplier<T> constructor, ModelProperty<T, Set<String>> valueModelProperty) {
        addTargetingCollectionValueMapper(builder, constructor, valueModelProperty,
                columnTitle -> maybeSetMapper(stringMapper(columnTitle)));
    }

    private static <T extends AdGroupAdditionalTargeting> void addTargetingWithSetOfDateValueMapper(
            ObjectExcelMapper.ObjectExcelMapperBuilder<AdGroupAdditionalTargetingRepresentation> builder,
            Supplier<T> constructor, ModelProperty<T, Set<LocalDate>> valueModelProperty) {
        addTargetingCollectionValueMapper(builder, constructor, valueModelProperty,
                columnTitle -> maybeSetMapper(localDateMapper(columnTitle)));
    }

    private static <T extends AdGroupAdditionalTargeting> void addTargetingWithListOfStringsValueMapper(
            ObjectExcelMapper.ObjectExcelMapperBuilder<AdGroupAdditionalTargetingRepresentation> builder,
            Supplier<T> constructor, ModelProperty<T, List<String>> valueModelProperty) {
        addTargetingCollectionValueMapper(builder, constructor, valueModelProperty,
                columnTitle -> maybeListMapper(stringMapper(columnTitle)));
    }

    private static <T extends AdGroupAdditionalTargeting, K, C extends Collection<K>> void addTargetingCollectionValueMapper(
            ObjectExcelMapper.ObjectExcelMapperBuilder<AdGroupAdditionalTargetingRepresentation> builder,
            Supplier<T> constructor, ModelProperty<T, C> valueModelProperty,
            Function<String, ExcelMapper<C>> mapperSupplier) {
        String title = getTargetingTitle(constructor);
        builder
                //targeting
                .field(r -> r.getAdditionalTargetingWithCollectionValue(valueModelProperty, true),
                        (r, values) -> r.setAdditionalTargetingWithCollectionValue(constructor, valueModelProperty,
                                true, values), mapperSupplier.apply(title))
                //filtering
                .field(r -> r.getAdditionalTargetingWithCollectionValue(valueModelProperty, false),
                        (r, values) -> r.setAdditionalTargetingWithCollectionValue(constructor, valueModelProperty,
                                false, values), mapperSupplier.apply(getNegativeTargetingTitle(title)));
    }

    private static <T extends AdGroupAdditionalTargeting, V extends UatraitsTargeting> void addUatraitsTargetingMapper(
            ObjectExcelMapper.ObjectExcelMapperBuilder<AdGroupAdditionalTargetingRepresentation> builder,
            Supplier<T> targetingConstructor, Supplier<V> valueConstructor,
            ModelProperty<T, List<V>> valueModelProperty,
            Map<Long, String> targetingValueEntryIdMapper) {
        String title = getTargetingTitle(targetingConstructor);
        var invertedTargetingValueEntryIdMapper = invertMap(targetingValueEntryIdMapper);
        builder
                //targeting
                .field(r -> r.getAdditionalUatraitsTargeting(valueModelProperty, targetingValueEntryIdMapper, true),
                        (r, values) -> r.setAdditionalUatraitsTargeting(targetingConstructor, valueConstructor,
                                valueModelProperty, invertedTargetingValueEntryIdMapper, true, values),
                        maybeListMapper(predicateCheckingMapper(stringMapper(title),
                                makeOneOfPredicate(invertedTargetingValueEntryIdMapper))))
                //filtering
                .field(r -> r.getAdditionalUatraitsTargeting(valueModelProperty, targetingValueEntryIdMapper, false),
                        (r, values) -> r.setAdditionalUatraitsTargeting(targetingConstructor, valueConstructor,
                                valueModelProperty, invertedTargetingValueEntryIdMapper, false, values),
                        maybeListMapper(predicateCheckingMapper(stringMapper(getNegativeTargetingTitle(title)),
                                makeOneOfPredicate(invertedTargetingValueEntryIdMapper))));
    }

    private static <T extends AdGroupAdditionalTargeting> void addDesktopTargetingMapper(
            ObjectExcelMapper.ObjectExcelMapperBuilder<AdGroupAdditionalTargetingRepresentation> builder,
            Supplier<T> targetingConstructor, ModelProperty<T, Set<Long>> valueModelProperty,
            Map<Long, String> targetingValueEntryIdMapper) {
        String title = getTargetingTitle(targetingConstructor);
        var invertedTargetingValueEntryIdMapper = invertMap(targetingValueEntryIdMapper);
        builder
                // targeting, any (Or)
                .field(r -> r.getAdditionalDesktopTargeting(valueModelProperty, targetingValueEntryIdMapper, true, ANY),
                        (r, values) -> r.setAdditionalDesktopTargeting(targetingConstructor,
                                valueModelProperty, invertedTargetingValueEntryIdMapper, true, ANY, values),
                        maybeSetMapper(predicateCheckingMapper(stringMapper(title),
                                makeOneOfPredicate(invertedTargetingValueEntryIdMapper))))
                // filtering (Not)
                .field(r -> r.getAdditionalDesktopTargeting(valueModelProperty, targetingValueEntryIdMapper, false),
                        (r, values) -> r.setAdditionalDesktopTargeting(targetingConstructor,
                                valueModelProperty, invertedTargetingValueEntryIdMapper, false, values),
                        maybeSetMapper(predicateCheckingMapper(stringMapper(getNegativeTargetingTitle(title)),
                                makeOneOfPredicate(invertedTargetingValueEntryIdMapper))))
                // targeting, all (And)
                .field(r -> r.getAdditionalDesktopTargeting(valueModelProperty, targetingValueEntryIdMapper, true, ALL),
                        (r, values) -> r.setAdditionalDesktopTargeting(targetingConstructor,
                                valueModelProperty, invertedTargetingValueEntryIdMapper, true, ALL, values),
                        maybeSetMapper(predicateCheckingMapper(stringMapper(getAllDoneTargetingTitle(title)),
                                makeOneOfPredicate(invertedTargetingValueEntryIdMapper))));
    }

    private static void addMobileAppTargetingMapper(  //TODO- возможно можно будет сделать более общим
                                                      ObjectExcelMapper.ObjectExcelMapperBuilder<AdGroupAdditionalTargetingRepresentation> builder) {
        String title = getTargetingTitle(MobileInstalledAppsAdGroupAdditionalTargeting.class);
        builder
                // targeting, any (Or)
                .field(r -> r.getMobileAppTargetingMapper(true, ANY),
                        (r, values) -> r.setMobileAppTargetingMapper(true, ANY, values),
                        maybeSetMapper(stringMapper(title)))
                // filtering (Not)
                .field(r -> r.getMobileAppTargetingMapper(false),
                        (r, values) -> r.setMobileAppTargetingMapper(false, values),
                        maybeSetMapper(stringMapper(getNegativeTargetingTitle(title))))
                .field(r -> r.getMobileAppTargetingMapper(true, ALL),
                        (r, values) -> r.setMobileAppTargetingMapper(true, ALL, values),
                        maybeSetMapper(stringMapper(getAllDoneTargetingTitle(title))));
    }

    private static <T extends AdGroupAdditionalTargeting, V extends VersionedTargeting> void addVersionedTargetingMapper(
            ObjectExcelMapper.ObjectExcelMapperBuilder<AdGroupAdditionalTargetingRepresentation> builder,
            Supplier<T> targetingConstructor, Supplier<V> valueConstructor,
            ModelProperty<T, List<V>> valueModelProperty,
            Map<Long, String> targetingValueEntryIdMapper) {
        String title = getTargetingTitle(targetingConstructor);
        var invertedTargetingValueEntryIdMapper = invertMap(targetingValueEntryIdMapper);
        var targetingObjectExcelMapper =
                getVersionedTargetingValueMapper(title, invertedTargetingValueEntryIdMapper);
        builder
                .field(r -> r.getVersionedAdditionalTargeting(valueModelProperty, targetingValueEntryIdMapper),
                        (r, values) -> r.setVersionedAdditionalTargeting(targetingConstructor, valueConstructor,
                                valueModelProperty, invertedTargetingValueEntryIdMapper, values),
                        maybeListMapper(targetingObjectExcelMapper));
    }

    private static ObjectExcelMapper<VersionedTargetingRepresentation> getVersionedTargetingValueMapper(
            String title, Map<String, Long> invertedTargetingValueEntryIdMapper) {
        return objectMapper(VersionedTargetingRepresentation::new)
                .field(VersionedTargetingRepresentation::getPositiveValue,
                        VersionedTargetingRepresentation::setPositiveValue,
                        maybePredicateCheckingMapper(stringMapper(title),
                                makeOneOfPredicate(invertedTargetingValueEntryIdMapper)))
                .field(VersionedTargetingRepresentation::getNegativeValue,
                        VersionedTargetingRepresentation::setNegativeValue,
                        maybePredicateCheckingMapper(stringMapper(getNegativeTargetingTitle(title)),
                                makeOneOfPredicate(invertedTargetingValueEntryIdMapper)))
                .field(VersionedTargetingRepresentation::getMinVersion,
                        VersionedTargetingRepresentation::setMinVersion, maybeStringMapper(title + " >="))
                .field(VersionedTargetingRepresentation::getMaxVersion,
                        VersionedTargetingRepresentation::setMaxVersion, maybeStringMapper(title + " <="))
                .build();
    }

    /**
     * Инвертирует мапу, для получения id значения таргетинга из словаря по значению
     * Приводит все значения в нижний регистр, чтобы можно было получить entryId без учета регистра введенного
     * значения в экселе
     */
    public static Map<String, Long> invertMap(Map<Long, String> targetingValueEntryIdMapper) {
        return EntryStream.of(targetingValueEntryIdMapper)
                .invert()
                .mapKeys(String::toLowerCase)
                .toImmutableMap();
    }

    /**
     * Делает из мапы соответствия string -> id предикат,
     * проверяющий, что данной строке соответствует какой-нибудь id.
     * Нужно для использования с predicateCheckingMapper.
     */
    private static Predicate<String> makeOneOfPredicate(Map<String, Long> invertedTargetingValueEntryIdMapper) {
        return str -> invertedTargetingValueEntryIdMapper.containsKey(str.toLowerCase());
    }

    /**
     * Конвертер в InterfaceLang из строки.
     * Строка приводится в нижний регистр, т.к. все значения в InterfaceLang хранятся в нижнем регистре
     */
    private static InterfaceLang toInterfaceLang(String value) {
        return InterfaceLang.fromTypedValue(value.toLowerCase());
    }

}
