package ru.yandex.direct.excel.processing.model.internalad.mappers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableMap;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.DistribSoftConstants;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.UaTraitsConstants;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargetingJoinType;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargetingMode;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.CallerReferrersAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidTypesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.DesktopInstalledAppsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.DeviceIdsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.FeaturesInPPAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasLCookieAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasPassportIdAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InterfaceLang;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InterfaceLangsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InternalNetworkAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsDefaultYandexSearchAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsPPLoggedInAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsVirusedAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsYandexPlusAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.MobileInstalledAppsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.PlusUserSegmentsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryOptionsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryReferersAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.SearchTextAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ShowDatesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.SidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.TestIdsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UserAgentsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UuidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexUidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexuidAgeAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YpCookiesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YsCookiesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserEnginesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceVendorsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsMobileAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsTabletAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsTouchAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsFamiliesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.excel.processing.model.ColumnsWithChoices;

import static com.google.common.base.Preconditions.checkArgument;
import static ru.yandex.direct.utils.FunctionalUtils.mapSet;

@ParametersAreNonnullByDefault
public class AdGroupAdditionalTargetingMapperSettings {

    private AdGroupAdditionalTargetingMapperSettings() {
    }

    private static final String NEGATIVE_TARGETING_TITLE_SUFFIX = " не";
    private static final String ALL_DONE_TARGETING_TITLE_SUFFIX = " (Выполнено все)";

    private static final Map<Class<? extends AdGroupAdditionalTargeting>, String> TARGETING_TITLE_BY_CLASS =
            getAdGroupTargetingTitleByClass();
    public static final List<ColumnsWithChoices> COLUMNS_WITH_CHOICES_LIST = getColumnsWithChoices();


    /**
     * Заголовки таргетингов
     * Если у таргетинга есть ограничивающие значения, то нужно добавить их в {@link #getColumnsWithChoices}
     */
    private static Map<Class<? extends AdGroupAdditionalTargeting>, String> getAdGroupTargetingTitleByClass() {
        return ImmutableMap.<Class<? extends AdGroupAdditionalTargeting>, String>builder()
                .put(ShowDatesAdGroupAdditionalTargeting.class, "Время (по Москве) совпадает с")
                .put(InternalNetworkAdGroupAdditionalTargeting.class, "Внутренняя сеть (Yandex user nets)")
                .put(InterfaceLangsAdGroupAdditionalTargeting.class, "Языки интерфейса (Interface lang)")
                .put(QueryReferersAdGroupAdditionalTargeting.class, "Маска сайта (Query Referers)")
                .put(CallerReferrersAdGroupAdditionalTargeting.class, "Реферер пользователя (Referer)")
                .put(UserAgentsAdGroupAdditionalTargeting.class, "Юзер-Агент (User-Agent)")
                .put(DesktopInstalledAppsAdGroupAdditionalTargeting.class,
                        "Установленный софт (десктоп) (Desktop installed apps)")
                .put(MobileInstalledAppsAdGroupAdditionalTargeting.class,
                        "Установленность приложения (Mobile installed apps)")
                .put(YsCookiesAdGroupAdditionalTargeting.class, "Кука YS (YS cookie)")
                .put(ClidsAdGroupAdditionalTargeting.class, "Клид (Clid)")
                .put(ClidTypesAdGroupAdditionalTargeting.class, "Тип клидов (Clid types)")
                .put(YandexuidAgeAdGroupAdditionalTargeting.class, "Возраст куки (Yandexuid age)")
                .put(YandexUidsAdGroupAdditionalTargeting.class, "Яндексуид (Yandexuid)")
                .put(TestIdsAdGroupAdditionalTargeting.class, "ID эксперимента (Test id)")
                .put(DeviceVendorsAdGroupAdditionalTargeting.class, "Производители устройств (Device Vendor)")
                .put(DeviceNamesAdGroupAdditionalTargeting.class, "Названия устройств (Device Name)")
                .put(IsMobileAdGroupAdditionalTargeting.class, "Мобильное устройство (isMobile)")
                .put(IsTabletAdGroupAdditionalTargeting.class, "Планшет (isTablet)")
                .put(IsTouchAdGroupAdditionalTargeting.class, "Тач-устройство (isTouch)")
                .put(OsFamiliesAdGroupAdditionalTargeting.class, "Семейства ОС (OS Family)")
                .put(OsNamesAdGroupAdditionalTargeting.class, "Операционные системы (OS Name)")
                .put(BrowserEnginesAdGroupAdditionalTargeting.class, "Движки браузеров (Browser Engine)")
                .put(BrowserNamesAdGroupAdditionalTargeting.class, "Браузеры (Browser Name)")
                .put(QueryOptionsAdGroupAdditionalTargeting.class, "Опции (Options)")
                .put(IsYandexPlusAdGroupAdditionalTargeting.class, "Включён Яндекс Плюс (isYandexPlus)")
                .put(IsVirusedAdGroupAdditionalTargeting.class, "Пометка о завирусованности")
                .put(HasLCookieAdGroupAdditionalTargeting.class, "Кука L")
                .put(HasPassportIdAdGroupAdditionalTargeting.class, "Passport ID")
                .put(IsDefaultYandexSearchAdGroupAdditionalTargeting.class, "Дефолтный поиск Яндекс")
                .put(IsPPLoggedInAdGroupAdditionalTargeting.class, "Авторизован в ПП")
                .put(FeaturesInPPAdGroupAdditionalTargeting.class, "Фичи включенные в ПП")
                .put(YpCookiesAdGroupAdditionalTargeting.class, "YP кука")
                .put(SidsAdGroupAdditionalTargeting.class, "SID")
                .put(UuidsAdGroupAdditionalTargeting.class, "UUID")
                .put(DeviceIdsAdGroupAdditionalTargeting.class, "Device ID")
                .put(PlusUserSegmentsAdGroupAdditionalTargeting.class, "Сегменты Плюса")
                .put(SearchTextAdGroupAdditionalTargeting.class, "Текст поискового запроса")
                .build();
    }

    public static String getTargetingTitle(AdGroupAdditionalTargeting targeting) {
        String targetingTitle = getTargetingTitle(targeting.getClass());

        if (targeting.getTargetingMode() == AdGroupAdditionalTargetingMode.TARGETING) {
            if (targeting.getJoinType() == AdGroupAdditionalTargetingJoinType.ANY) {
                return targetingTitle;
            }
            return getAllDoneTargetingTitle(targetingTitle);
        }

        return getNegativeTargetingTitle(targetingTitle);
    }

    static <T extends AdGroupAdditionalTargeting> String getTargetingTitle(Supplier<T> targetingConstructor) {
        return getTargetingTitle(targetingConstructor.get().getClass());
    }

    static String getTargetingTitle(Class<? extends AdGroupAdditionalTargeting> targetingClass) {
        checkArgument(TARGETING_TITLE_BY_CLASS.containsKey(targetingClass),
                "unknown title for targetingClass: " + targetingClass.getSimpleName());
        return TARGETING_TITLE_BY_CLASS.get(targetingClass);
    }

    public static String getNegativeTargetingTitle(String targetingTitle) {
        return targetingTitle + NEGATIVE_TARGETING_TITLE_SUFFIX;
    }

    public static String getAllDoneTargetingTitle(String targetingTitle) {
        return targetingTitle + ALL_DONE_TARGETING_TITLE_SUFFIX;
    }

    private static List<ColumnsWithChoices> getColumnsWithChoices() {
        var targetingsWithYesNoValue = Set.of(InternalNetworkAdGroupAdditionalTargeting.class,
                IsMobileAdGroupAdditionalTargeting.class, IsTabletAdGroupAdditionalTargeting.class,
                IsTouchAdGroupAdditionalTargeting.class, IsYandexPlusAdGroupAdditionalTargeting.class,
                IsVirusedAdGroupAdditionalTargeting.class,
                HasLCookieAdGroupAdditionalTargeting.class, HasPassportIdAdGroupAdditionalTargeting.class,
                IsDefaultYandexSearchAdGroupAdditionalTargeting.class, IsPPLoggedInAdGroupAdditionalTargeting.class);
        Set<String> titlesWithYesNoValue =
                mapSet(targetingsWithYesNoValue, AdGroupAdditionalTargetingMapperSettings::getTargetingTitle);

        Set<String> interfaceLangs = StreamEx.of(InterfaceLang.values())
                .map(InterfaceLang::getTypedValue)
                .toImmutableSet();

        var builder = ColumnsWithChoices.listBuilder()
                .addColumnsWithYesOrNoChoices(titlesWithYesNoValue);

        addChoicesForTargetingWithNegativeColumn(builder,
                InterfaceLangsAdGroupAdditionalTargeting.class, interfaceLangs);
        addChoicesForTargetingWithNegativeAndAllDoneColumns(builder,
                DesktopInstalledAppsAdGroupAdditionalTargeting.class, DistribSoftConstants.DISTRIB_SOFT);
        addChoicesForTargetingWithNegativeColumn(builder,
                DeviceVendorsAdGroupAdditionalTargeting.class, UaTraitsConstants.DEVICE_VENDOR);
        addChoicesForTargetingWithNegativeColumn(builder,
                OsFamiliesAdGroupAdditionalTargeting.class, UaTraitsConstants.OS_FAMILY);
        addChoicesForTargetingWithNegativeColumn(builder,
                OsNamesAdGroupAdditionalTargeting.class, UaTraitsConstants.OS_NAME);
        addChoicesForTargetingWithNegativeColumn(builder,
                BrowserNamesAdGroupAdditionalTargeting.class, UaTraitsConstants.BROWSER_NAME);
        addChoicesForTargetingWithNegativeColumn(builder,
                BrowserEnginesAdGroupAdditionalTargeting.class, UaTraitsConstants.BROWSER_ENGINE);

        return builder.build();
    }

    private static void addChoicesForTargetingWithNegativeColumn(ColumnsWithChoices.ColumnsWithChoicesListBuilder builder,
                                                                 Class<? extends AdGroupAdditionalTargeting> targetingClass,
                                                                 Map<?, String> mapWithValues) {
        addChoicesForTargetingWithNegativeColumn(builder, targetingClass, mapWithValues.values());
    }

    private static void addChoicesForTargetingWithNegativeColumn(ColumnsWithChoices.ColumnsWithChoicesListBuilder builder,
                                                                 Class<? extends AdGroupAdditionalTargeting> targetingClass,
                                                                 Collection<String> values) {
        addChoicesForTargetingWithColumns(builder, targetingClass, values, true, false);
    }

    private static void addChoicesForTargetingWithNegativeAndAllDoneColumns(
            ColumnsWithChoices.ColumnsWithChoicesListBuilder builder,
            Class<? extends AdGroupAdditionalTargeting> targetingClass,
            Map<?, String> mapWithValues) {
        addChoicesForTargetingWithNegativeAndAllDoneColumns(builder, targetingClass, mapWithValues.values());
    }

    private static void addChoicesForTargetingWithNegativeAndAllDoneColumns(
            ColumnsWithChoices.ColumnsWithChoicesListBuilder builder,
            Class<? extends AdGroupAdditionalTargeting> targetingClass,
            Collection<String> values) {
        addChoicesForTargetingWithColumns(builder, targetingClass, values, true, true);
    }

    private static void addChoicesForTargetingWithColumns(ColumnsWithChoices.ColumnsWithChoicesListBuilder builder,
                                                          Class<? extends AdGroupAdditionalTargeting> targetingClass,
                                                          Collection<String> values,
                                                          boolean addNegativeColumn,
                                                          boolean addAllDoneColumn) {
        String title = getTargetingTitle(targetingClass);
        Set<String> columnTitles = new LinkedHashSet<>();
        columnTitles.add(title);
        if (addNegativeColumn) {
            columnTitles.add(getNegativeTargetingTitle(title));
        }
        if (addAllDoneColumn) {
            columnTitles.add(getAllDoneTargetingTitle(title));
        }
        builder.addColumnTitlesWithChoices(columnTitles, values);
    }
}
