package ru.yandex.direct.excel.processing.model.internalad.mappers;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.InternalAdGroup;
import ru.yandex.direct.core.entity.adgroup.repository.typesupport.InternalAdGroupSupport;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.excel.processing.model.internalad.InternalAdGroupRepresentation;
import ru.yandex.direct.excel.processing.service.internalad.CryptaSegmentDictionariesService;
import ru.yandex.direct.excelmapper.ExcelMapper;

import static ru.yandex.direct.excel.processing.model.internalad.mappers.AdGroupAdditionalTargetingMapper.AD_GROUP_TARGETING_MAPPER;
import static ru.yandex.direct.excel.processing.model.internalad.mappers.AdGroupAdditionalTargetingMapperSettings.getNegativeTargetingTitle;
import static ru.yandex.direct.excel.processing.model.internalad.mappers.RetargetingBaseMappers.getRetargetingMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.listMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.longMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.maybeIntMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.maybeIntZeroToNullMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.maybeListMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.maybeLocalDateTimeMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.maybeLongMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.modelMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.objectMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.stringMapper;

@ParametersAreNonnullByDefault
public class AdGroupMappers {

    private static final String REGIONS_TITLE = "Регион";

    private static final String AD_GROUP_ID_TITLE = "ID";
    private static final String AD_GROUP_NAME_TITLE = "Название";
    private static final String AD_GROUP_LEVEL_TITLE = "Приоритет";
    private static final String AD_GROUP_START_TIME_TITLE = "Начало показов";
    private static final String AD_GROUP_FINISH_TIME_TITLE = "Окончание показов";
    private static final String AD_GROUP_RF_TITLE = "rf";
    private static final String AD_GROUP_RF_RESET_TITLE = "Период Rf";
    private static final String AD_GROUP_MAX_CLICKS_COUNT_TITLE = "Количество кликов";
    private static final String AD_GROUP_MAX_CLICKS_PERIOD_TITLE = "Период закрытия по кликам";
    private static final String AD_GROUP_MAX_STOPS_COUNT_TITLE = "Количество отказов";
    private static final String AD_GROUP_MAX_STOPS_PERIOD_TITLE = "Период закрытия по отказам";

    public static final Set<String> NON_HIDDEN_TITLES = Set.of(
            AD_GROUP_LEVEL_TITLE, AD_GROUP_START_TIME_TITLE, AD_GROUP_FINISH_TIME_TITLE,
            AD_GROUP_RF_TITLE, AD_GROUP_RF_RESET_TITLE,
            AD_GROUP_MAX_CLICKS_COUNT_TITLE, AD_GROUP_MAX_CLICKS_PERIOD_TITLE,
            AD_GROUP_MAX_STOPS_COUNT_TITLE, AD_GROUP_MAX_STOPS_PERIOD_TITLE,
            REGIONS_TITLE, getNegativeTargetingTitle(REGIONS_TITLE)
    );

    private AdGroupMappers() {
    }

    private static ExcelMapper<InternalAdGroup> getInternalAdGroupMapper(CampaignType campaignType) {
        var mapper = modelMapper(InternalAdGroup::new)
                .field(AdGroup.ID, maybeLongMapper(AD_GROUP_ID_TITLE))
                .field(AdGroup.NAME, stringMapper(AD_GROUP_NAME_TITLE));
        if (campaignType == CampaignType.INTERNAL_FREE) {
            mapper.field(InternalAdGroup.LEVEL, longMapper(AD_GROUP_LEVEL_TITLE));
        } else {
            // показываем столбец, но игнорим значение при импорте: https://st.yandex-team.ru/DIRECT-149976
            mapper.readOnlyFieldWithDefaultValue(InternalAdGroup.LEVEL, longMapper(AD_GROUP_LEVEL_TITLE),
                    InternalAdGroupSupport.DEFAULT_LEVEL);
        }
        return mapper
                .field(InternalAdGroup::getStartTime, InternalAdGroup::setStartTime,
                        maybeLocalDateTimeMapper(AD_GROUP_START_TIME_TITLE))
                .field(InternalAdGroup::getFinishTime, InternalAdGroup::setFinishTime,
                        maybeLocalDateTimeMapper(AD_GROUP_FINISH_TIME_TITLE))
                .field(InternalAdGroup.RF, maybeIntMapper(AD_GROUP_RF_TITLE))
                .field(InternalAdGroup.RF_RESET, maybeIntZeroToNullMapper(AD_GROUP_RF_RESET_TITLE))
                .build();
    }

    public static ExcelMapper<InternalAdGroupRepresentation> getInternalAdGroupsMapper(CampaignType campaignType,
                                                                                       CryptaSegmentDictionariesService cryptaSegmentDictionariesService) {
        return objectMapper(InternalAdGroupRepresentation::new)
                .field(InternalAdGroupRepresentation::getAdGroup, InternalAdGroupRepresentation::setAdGroup,
                        getInternalAdGroupMapper(campaignType))
                .field(InternalAdGroupRepresentation::getMaxClicksCount,
                        InternalAdGroupRepresentation::setMaxClicksCount,
                        maybeIntMapper(AD_GROUP_MAX_CLICKS_COUNT_TITLE))
                .field(InternalAdGroupRepresentation::getMaxClicksPeriod,
                        InternalAdGroupRepresentation::setMaxClicksPeriod,
                        maybeIntZeroToNullMapper(AD_GROUP_MAX_CLICKS_PERIOD_TITLE))
                .field(InternalAdGroupRepresentation::getMaxStopsCount,
                        InternalAdGroupRepresentation::setMaxStopsCount,
                        maybeIntMapper(AD_GROUP_MAX_STOPS_COUNT_TITLE))
                .field(InternalAdGroupRepresentation::getMaxStopsPeriod,
                        InternalAdGroupRepresentation::setMaxStopsPeriod,
                        maybeIntZeroToNullMapper(AD_GROUP_MAX_STOPS_PERIOD_TITLE))
                .field(InternalAdGroupRepresentation::getGeoIncluded,
                        InternalAdGroupRepresentation::setGeoIncluded,
                        listMapper(longMapper(REGIONS_TITLE)))
                .field(InternalAdGroupRepresentation::getGeoExcluded,
                        InternalAdGroupRepresentation::setGeoExcluded,
                        maybeListMapper(longMapper(getNegativeTargetingTitle(REGIONS_TITLE))))
                .field(InternalAdGroupRepresentation::getTargetingRepresentation,
                        InternalAdGroupRepresentation::setTargetingRepresentation, AD_GROUP_TARGETING_MAPPER)
                .field(InternalAdGroupRepresentation::getRetargetingConditionRepresentation,
                        InternalAdGroupRepresentation::setRetargetingConditionRepresentation,
                        getRetargetingMapper(cryptaSegmentDictionariesService))
                .build();
    }

}
