package ru.yandex.direct.excel.processing.model.internalad.mappers;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.apache.commons.collections4.CollectionUtils;

import ru.yandex.direct.core.entity.internalads.model.ResourceChoice;
import ru.yandex.direct.core.entity.internalads.model.ResourceInfo;
import ru.yandex.direct.excel.processing.model.ColumnsWithChoices;

import static ru.yandex.direct.excel.processing.model.internalad.mappers.BannerMappers.IS_SECRET_AD_TITLE;
import static ru.yandex.direct.excel.processing.model.internalad.mappers.BannerMappers.STATUS_SEND_TO_MODERATION_TITLE;
import static ru.yandex.direct.excel.processing.model.internalad.mappers.BannerMappers.STATUS_SHOW_AFTER_MODERATION_TITLE;
import static ru.yandex.direct.excel.processing.model.internalad.mappers.BannerMappers.STATUS_SHOW_TITLE;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class BannerMapperSettings {

    private static final Set<String> COLUMNS_WITH_YES_NO_VALUE = Set.of(STATUS_SHOW_TITLE);
    private static final Set<String> COLUMNS_WITH_YES_NO_VALUE_FOR_MODERATED_PLACE = Set.of(
            STATUS_SEND_TO_MODERATION_TITLE, STATUS_SHOW_AFTER_MODERATION_TITLE, IS_SECRET_AD_TITLE);

    private BannerMapperSettings() {
    }

    public static List<ColumnsWithChoices> getColumnsWithChoices(List<ResourceInfo> resources, boolean isModerated) {
        var builder = ColumnsWithChoices.listBuilder()
                .addColumnsWithYesOrNoChoices(COLUMNS_WITH_YES_NO_VALUE);

        if (isModerated) {
            builder.addColumnsWithYesOrNoChoices(COLUMNS_WITH_YES_NO_VALUE_FOR_MODERATED_PLACE);
        }

        StreamEx.of(resources)
                .mapToEntry(ResourceInfo::getLabel, ResourceInfo::getChoices)
                .filterValues(CollectionUtils::isNotEmpty)
                // Показывать для ресурсов с выбором значений - отображаемое название варианта
                .mapValues(choices -> mapList(choices, ResourceChoice::getDisplay))
                .mapKeys(Set::of)
                .forKeyValue(builder::addColumnTitlesWithChoices);

        return builder.build();
    }

}
