package ru.yandex.direct.excel.processing.model.internalad.mappers;

import java.util.regex.Pattern;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.excel.processing.model.internalad.CryptaSegment;
import ru.yandex.direct.excelmapper.SheetRange;
import ru.yandex.direct.excelmapper.mappers.AbstractSimpleTypeExcelMapper;

/**
 * Маппер для строки с крипто-сегментом
 * Формате id киворда:id сегмента, например: 549:1631
 */
@ParametersAreNonnullByDefault
public class CryptaSegmentMapper extends AbstractSimpleTypeExcelMapper<CryptaSegment> {

    private static final Pattern CRYPTA_SEGMENT_FORMAT = Pattern.compile("^\\d+:\\d+$");

    CryptaSegmentMapper(String title) {
        super(title);
    }

    @Override
    protected String convertValueToWrite(CryptaSegment cryptaSegment) {
        return String.format("%s:%s", cryptaSegment.getKeywordId(), cryptaSegment.getSegmentId());
    }

    @Nonnull
    @Override
    protected CryptaSegment convertValueToRead(String stringCellValue, SheetRange sheetRange) {
        if (CRYPTA_SEGMENT_FORMAT.matcher(stringCellValue).matches()) {
            String[] split = stringCellValue.split(":");
            return CryptaSegment.create(split[0], split[1]);
        } else {
            sheetRange.reportCantReadFormat(getMeta().getColumns(), ROW, COL);
        }
        // недостижимое место
        throw new IllegalStateException();
    }

}
