package ru.yandex.direct.excel.processing.model.internalad.mappers;

import java.util.List;
import java.util.regex.Pattern;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.collections.CollectionUtils;

import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.excelmapper.SheetRange;
import ru.yandex.direct.excelmapper.exceptions.CantWriteEmptyException;
import ru.yandex.direct.excelmapper.exceptions.CantWriteFormatException;
import ru.yandex.direct.excelmapper.mappers.AbstractSimpleTypeExcelMapper;

import static ru.yandex.direct.excel.processing.model.internalad.RulesConverter.convertRulesToString;
import static ru.yandex.direct.excel.processing.model.internalad.RulesConverter.convertStringToRules;

/**
 * Маппер для строк правил ретаргетинга
 * например, (100500:2)&(~20141023:21)&(20141020:1|20141025:2)
 */
@ParametersAreNonnullByDefault
public class GoalContextMapper extends AbstractSimpleTypeExcelMapper<List<Rule>> {
    private static final Pattern RULES_FORMAT = Pattern.compile("^\\((~\\d+:\\d+|\\d+:\\d+(\\|\\d+:\\d+)*)\\)(&\\(" +
            "(~\\d+:\\d+|\\d+:\\d+(\\|\\d+:\\d+)*)\\))*$");

    GoalContextMapper(String title) {
        super(title);
    }

    @Override
    protected String convertValueToWrite(List<Rule> rules) {
        if (CollectionUtils.isEmpty(rules)) {
            throw new CantWriteEmptyException(getMeta().getColumns());
        }
        try {
            return convertRulesToString(rules);
        } catch (IllegalArgumentException e) {
            throw new CantWriteFormatException(getMeta().getColumns());
        }
    }

    @Nonnull
    @Override
    protected List<Rule> convertValueToRead(String stringCellValue, SheetRange sheetRange) {
        if (RULES_FORMAT.matcher(stringCellValue).matches()) {
            try {
                return convertStringToRules(stringCellValue);
            } catch (IllegalArgumentException e) {
                sheetRange.reportCantReadFormat(getMeta().getColumns(), ROW, COL);
            }
        } else {
            sheetRange.reportCantReadFormat(getMeta().getColumns(), ROW, COL);
        }
        // недостижимое место
        throw new IllegalStateException();
    }
}
